<?php


namespace MageCloud\Motorcyclepartswarehouse\ViewModel\Category;

use Magento\Framework\View\Element\Block\ArgumentInterface,
    Magento\Framework\Registry,
    Magento\Catalog\Api\Data\CategoryInterface;

class Title implements ArgumentInterface
{
    private $registry;

    public function __construct(Registry $registry)
    {
        $this->registry = $registry;
    }

    public function showPageTitle(): bool
    {
        $currentCategory = $this->getCurrentCategory();
        if (!$currentCategory) {
            return true;
        }

        $description = $currentCategory->getDescription();
        if (strstr($description, '<h1>')) {
            return false;
        }

        return true;
    }

    private function getCurrentCategory(): ?CategoryInterface
    {
        $category = $this->registry->registry('current_category');
        if ($category) {
            return $category;
        }

        return null;
    }
}