<?php
/**
 * Created by PhpStorm.
 * User: 1
 * Date: 11.12.2020
 * Time: 21:17
 */

declare(strict_types=1);

namespace MageCloud\Motorcyclepartswarehouse\ViewModel\Offers;

use Magento\Framework\View\Element\Block\ArgumentInterface,
    Magento\Catalog\Model\Locator\RegistryLocator,
    Magento\Framework\App\RequestInterface,
    Magento\CatalogInventory\Api\StockItemRepositoryInterface,
    Magento\Store\Model\StoreManagerInterface,
    Magento\Framework\UrlInterface,
    Magento\Review\Model\ReviewFactory,
    Magento\Catalog\Api\ProductRepositoryInterface;

class Product implements ArgumentInterface
{
    const PRODUCT_PAGE = 'catalog_product_view';

    const IN_STOCK = 'https://schema.org/InStock';

    const OUT_OF_STOCK = 'https://schema.org/OutOfStock';

    private $productResolver;

    private $request;

    private $stockItemRepository;

    private $storeManager;

    public function __construct(
        RegistryLocator $productResolver,
        RequestInterface $request,
        StockItemRepositoryInterface $stockItemRepository,
        StoreManagerInterface $storeManager
    ) {
        $this->productResolver = $productResolver;
        $this->request = $request;
        $this->stockItemRepository = $stockItemRepository;
        $this->storeManager = $storeManager;
    }

    public function isProductPage(): bool
    {
        return $this->request->getFullActionName() === self::PRODUCT_PAGE;
    }

    public function getAvailability(): ?string
    {
        $product = $this->getProduct();
        if (!$product) {
            return null;
        }

        $stock = $this->stockItemRepository->get($product->getId());
        if (!$stock) {
            return null;
        }

        return $stock->getIsInStock() ? self::IN_STOCK : self::OUT_OF_STOCK;
    }

    public function getPriceCode(): string
    {
        return $this->storeManager->getStore()->getCurrentCurrency()->getCode();
    }

    public function getPrice(): ?string
    {
        $product = $this->getProduct();
        if (!$product) {
            return '';
        }

        return $product->getData('price') ? $product->getData('price') : '';
    }

    public function getUrl(): string
    {
        $product = $this->getProduct();
        if (!$product) {
            return '';
        }

        $productUrl = $product->getData('url_key');
        $baseUrl = $this->storeManager->getStore()->getBaseUrl(UrlInterface::URL_TYPE_WEB);

        return $productUrl ? $baseUrl . $productUrl : '';
    }

    public function isConfWithoutSimples(): bool
    {
        $product = $this->getProduct();
        if ($product->getTypeId() === 'configurable') {
            if (count($product->getTypeInstance()->getUsedProducts($product)) === 0 ||
                !$product->isSalable()
            ) {
                return true;
            }
        }
        return false;
    }

    public function getBrand(): string
    {
        $brand = '';
        $product = $this->getProduct();
        if ($manufacturer = $product->getAttributeText('manufacturer')) {
            $brand .= $manufacturer;
        }

        return $brand;
    }

    public function getImage(): string
    {
        $productImageUrl = '';
        $store = $this->storeManager->getStore();

        $product = $this->getProduct();
        $productImageUrl .= $store->getBaseUrl(UrlInterface::URL_TYPE_MEDIA) . 'catalog/product' . $product->getImage();

        return $productImageUrl;
    }

    public function getDescription(): string
    {
        $description = '';
        $product = $this->getProduct();
        if ($product->getDescription()) {
            $description .= $product->getDescription();
        }

        return $description;
    }

    public function getProduct()
    {
        return $this->productResolver->getProduct();
    }
}