<?php
/**
 * Copyright (c) 2020. Volodymyr Hryvinskyi.  All rights reserved.
 * @author: <mailto:volodymyr@hryvinskyi.com>
 * @github: <https://github.com/hryvinskyi>
 */

declare(strict_types=1);

namespace MageCloud\SeoRatingSnippet\ViewModel;

use MageCloud\SeoRatingSnippet\Model\Config;
use Magento\Framework\App\Request\Http;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\View\Page\Title;

/**
 * Class RatingData
 */
class RatingData implements ArgumentInterface
{
    /**
     * @var Title
     */
    private $pageTitle;

    /**
     * @var Config
     */
    private $config;

    /**
     * @var Http
     */
    private $request;

    /**
     * @var array
     */
    private $pageTypes;

    /**
     * RatingData constructor.
     *
     * @param Title $pageTitle
     * @param Config $config
     * @param Http $request
     * @param array $pageTypes
     */
    public function __construct(
        Title $pageTitle,
        Config $config,
        Http $request,
        array $pageTypes = []
    ) {
        $this->pageTitle = $pageTitle;
        $this->config = $config;
        $this->request = $request;
        $this->pageTypes = $pageTypes;
    }

    /**
     * @return string
     */
    public function getPageTitle(): string
    {
        return (string)$this->pageTitle->getShort();
    }

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->config->getValue();
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        return $this->config->isEnabled();
    }

    /**
     * @return string
     */
    public function getCount(): string
    {
        return $this->config->getCount();
    }

    /**
     * @return bool
     */
    public function isShowRating(): bool
    {
        return in_array($this->request->getFullActionName(), $this->pageTypes);
    }
}