<?php
namespace Magebees\Gdpr\Block\Address;
use Magento\Framework\View\Element\Template;
use Magebees\Gdpr\Helper\Data as HelperData;

class Account extends Template
{
    protected $_helperData;
	public $_storeManager;

    public function __construct(
        Template\Context $context,
        HelperData $helperData,
        array $data = []
    ) {
        $this->_helperData = $helperData;
		$this->_storeManager = $context->getStoreManager();
        parent::__construct($context, $data);
    }
    public function getDeleteAccountMessage()
    {
        $deleteAccountMessage = $this->_helperData->getDeleteAccountMessage();
        $defaultMassage = __('Your account will be permanently deleted. Once you delete your account, there is no going back. Please be certain.');

        return $deleteAccountMessage ?: $defaultMassage;
    }
    public function allowDeleteAccount()
    {
        return $this->_helperData->allowDeleteAccount();
    }
	public function getDelConfigText()
    {
        return $this->_helperData->getDelConfigText();
    }
    public function getExtraData()
    {
        return HelperData::jsonEncode([]);
    }	
    public function getDeleteAccountUrl()
    {
        return $this->getUrl('customer/account/delete');
    }
	public function allowPrivecyPolicy($storeId = null)
    {
		return $this->_helperData->allowPrivecyPolicy();
    }
	public function ppcheckboxtext($storeId = null)
    {
		return $this->_helperData->ppcheckboxtext();
    }
	public function ppcontentpage($storeId = null)
    {
		return $this->_helperData->ppcontentpage();
    }
	public function getMoreInfoPageUrl($cmspage) {
        return $this->_storeManager->getStore()->getUrl($cmspage);

    }
}