<?php
namespace Magebees\Gdpr\Controller\Account;
use Exception;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Controller\AbstractAccount;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Customer\Model\Session;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\DataObject;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Registry;
use Magento\Framework\Stdlib\Cookie\CookieMetadataFactory;
use Magento\Framework\Stdlib\Cookie\PhpCookieManager;
use Magebees\Gdpr\Helper\Data;
use Psr\Log\LoggerInterface;

class Download extends AbstractAccount
{
    protected $_customerRepository;
    protected $_customerSession;
    protected $registry;
    protected $logger;
    protected $_helper;
    private $cookieMetadataFactory;
    private $cookieMetadataManager;

    public function __construct(
        Context $context,
        CustomerRepositoryInterface $customerRepository,
        Session $customerSession,
        Registry $registry,
        LoggerInterface $logger,
        Data $helper
    ) {
        $this->_customerRepository = $customerRepository;
        $this->_customerSession = $customerSession;
        $this->registry = $registry;
        $this->logger = $logger;
        $this->_helper = $helper;

        parent::__construct($context);
    }
    public function execute()
    {	
        if (!$this->_helper->allowDeleteAccount() || !$this->_customerSession->isLoggedIn()) {
            $this->registry->register('use_page_cache_plugin', false);
            $this->_forward('noRoute');
            return;
        }
        $customerId = $this->_customerSession->getCustomerId();
        //$customer = $this->_customerRepository->getById($customerId);
        
		//$customer_id=7;
		$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
		$customerData = $objectManager->create('Magento\Customer\Model\Customer')->load($customerId);
		
		//echo "<pre>";
		//print_r($customerData->getData());
		//die;
		
		
		//$checktoken = new DataObject(['flag' => true]);

        //$this->_eventManager->dispatch('anonymise_account_before_delete', compact('customer', 'checktoken'));

        //if (!$checktoken->getFlag()) {
            //$this->registry->register('use_page_cache_plugin', false);
            //$this->_forward('noRoute');
            //return;
        //}
		
		
		//echo "<pre>";
		//print_r($array);
		//die;
		$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
		$filesystem = $objectManager->get('Magento\Framework\Filesystem');
        $extvardir = $filesystem->getDirectoryWrite(DirectoryList::VAR_DIR);
        $exportdir = '/export';
        $extvardir->create($exportdir);
        $extvardir->changePermissions($exportdir, DriverInterface::WRITEABLE_DIRECTORY_MODE);
        $export_file_name = "exportcmsblocks_".date('m-d-Y_h-i-s', time()).".csv";
		
		$filePath = $filesystem->getDirectoryRead(DirectoryList::VAR_DIR)->getAbsolutePath("export/").$export_file_name;
		
		$files = fopen($filePath, "w");
        fputCsv($files, $customerData);
        fclose($files);
		$resultRedirect = $this->resultRedirectFactory->create();
		$resultRedirect->setPath('*/*/');
        return $resultRedirect;
    }
	
    private function getCookieManager()
    {
        if (!$this->cookieMetadataManager) {
            $this->cookieMetadataManager = ObjectManager::getInstance()->get(PhpCookieManager::class);
        }
        return $this->cookieMetadataManager;
    }
    private function getCookieMetadataFactory()
    {
        if (!$this->cookieMetadataFactory) {
            $this->cookieMetadataFactory = ObjectManager::getInstance()->get(CookieMetadataFactory::class);
        }
        return $this->cookieMetadataFactory;
    }
}