<?php
namespace Magebees\Gdpr\Helper;
use Magento\Framework\View\Design\Theme\ThemeProviderInterface;
use Magento\Framework\View\DesignInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\Area;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\Json\Helper\Data as JsonHelper;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{	
	protected $_storeManager;
	protected $scopeConfig;
    protected $backendConfig;
	protected $isArea = [];
    protected $objectManager;
	
	public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        ObjectManagerInterface $objectManager
    ) {
		$this->_storeManager = $storeManager;
        $this->objectManager = $objectManager;
        parent::__construct($context);
	}
	
	public function getConfig($config_path)
    {
        return $this->scopeConfig->getValue(
            $config_path,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }
	public function isEnabled()
    {
		return $this->getConfig('gdpr/general/enabled');
    }
	
    public function allowDeleteAccount($storeId = null)
    {
        return $this->isEnabled() && $this->getConfig('gdpr/gdprcustomer/allowDelCus');
    }
	public function getDelConfigText($storeId = null)
    {	
		$delConfigText = $this->getConfig('gdpr/gdprcustomer/delConftext');
		if(trim($delConfigText) == ""){
			$delConfigText = __("Are you sure you want to delete your account?");
		}
        return $delConfigText;
    }
    public function getDeleteAccountMessage($storeId = null)
    {
		return $this->getConfig('gdpr/gdprcustomer/delCustMsg');
    }
    public function getDeleteAccountUrl()
    {
        return $this->_getUrl('customer/gdprcustomer/delete');
    }
    public function allowDeleteDefaultAddress($storeId = null)
    {
		return $this->isEnabled() && $this->getConfig('gdpr/gdprcustomer/allowDelDefaultAddress');
    }
    public function getExtraData()
    {
        return $this->jsonEncode([]);
    }
	
	public static function getJsonHelper()
    {
        //return $this->objectManager->get(JsonHelper::class);
		return ObjectManager::getInstance()->get(JsonHelper::class);
    }
	
	public static function jsonEncode($valueToEncode)
    {
        try {
            $encodeValue = self::getJsonHelper()->jsonEncode($valueToEncode);
        } catch (Exception $e) {
            $encodeValue = '{}';
        }
        return $encodeValue;
    }
	
	public static function jsonDecode($encodedValue)
    {
        try {
            $decodeValue = self::getJsonHelper()->jsonDecode($encodedValue);
        } catch (Exception $e) {
            $decodeValue = [];
        }
        return $decodeValue;
    }
	
	public function clEnable()
    {
		return $this->getConfig('gdpr/cookielaw/clenable');
    }
	public function clStyle()
    {
		return $this->getConfig('gdpr/cookielaw/clstyle');
    }
	public function clPosition()
    {
		return $this->getConfig('gdpr/cookielaw/clposition');
    }
	public function clPositionbox()
    {
		return $this->getConfig('gdpr/cookielaw/clpositionbox');
    }
	public function clFontcolor()
    {
		return $this->getConfig('gdpr/cookielaw/clfontcolor');
    }
	public function clBackgroundcolor()
    {
		return $this->getConfig('gdpr/cookielaw/clbackgroundcolor');
    }
	public function clNoticeinterval()
    {
		return $this->getConfig('gdpr/cookielaw/clnoticeinterval');
    }
	public function clAutohide()
    {
		return $this->getConfig('gdpr/cookielaw/clautohide');
    }
	public function clContent()
    {
		return $this->getConfig('gdpr/cookielaw/clcontent');
    }
	public function clCustomtext()
    {
		return $this->getConfig('gdpr/cookielaw/clcustomtext');
    }
	public function clClosetext()
    {
		return $this->getConfig('gdpr/cookielaw/clclosetext');
    }
	public function clMoreinfotext()
    {
		return $this->getConfig('gdpr/cookielaw/clmoreinfotext');
    }
	public function clInformationpage()
    {
		return $this->getConfig('gdpr/cookielaw/clinformationpage');
    }
	public function allowPrivecyPolicy($storeId = null)
    {
        return $this->isEnabled() && $this->getConfig('gdpr/privecypolicy/ppenable');
    }
	public function ppcheckboxtext($storeId = null)
    {
        return $this->getConfig('gdpr/privecypolicy/ppcheckboxtext');
    }
	public function ppcontentpage($storeId = null)
    {
        return $this->getConfig('gdpr/privecypolicy/ppcontentpage');
    }
	
	public function enableAnonymous($storeId = null)
    {
        return $this->isEnabled() && $this->getConfig('gdpr/gdprcustomer/allow_customer_to_anonymous_account');
    }
	public function getAnonymousOrderStatus($storeId = null)
    {
        return $this->getConfig('gdpr/gdprcustomer/anonymous_order_status');
    }
	public function getAnonymousEmail($storeId = null)
    {
        return $this->getConfig('gdpr/gdprcustomer/anonymised_account_details_email_template');
    }
	public function getAnonymousWarningMsg($storeId = null)
    {
        return $this->getConfig('gdpr/gdprcustomer/anonymous_account_warning_message');
    }
	
	
	
	
	
	
}