<?php
namespace Magebees\Gdpr\Setup;
use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\DB\Ddl\Table;

class InstallSchema implements InstallSchemaInterface
{
    public function install(
        SchemaSetupInterface $setup,
        ModuleContextInterface $context
    ) {
        $installer = $setup;
        $installer->startSetup();
        $anonymousTable = $installer->getConnection()
            ->newTable($installer->getTable('magebees_gdpr_anonymous_account_history'))
            ->addColumn(
                'anonymous_account_id',
                Table::TYPE_SMALLINT,
                null,
                ['identity' => true, 'nullable' => false, 'primary' => true],
                'Anonymous Account ID'
            )
            ->addColumn(
                'customer_id',
                Table::TYPE_SMALLINT,
                null,
                ['nullable' => false],
                'Customer ID'
            )
            ->addColumn(
                'email',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false],
                'Customer Email'
            )
            ->addColumn(
                'is_anonymous',
                Table::TYPE_BOOLEAN,
                null,
                [],
                'Is Anonymous'
            )->setComment('Anonymous Account History');
        $installer->getConnection()->createTable($anonymousTable);
        $installer->getConnection()->addIndex(
            $installer->getTable('magebees_gdpr_anonymous_account_history'),
            $installer->getIdxName(
                $installer->getTable('magebees_gdpr_anonymous_account_history'),
                ['email'],
                \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT
            ),
            ['email'],
            \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT
        );

        $installer->endSetup();
    }
}
