<?php
namespace MpwOwn\BatteryWarranty\Setup;

class InstallSchema implements \Magento\Framework\Setup\InstallSchemaInterface
{

    public function install(\Magento\Framework\Setup\SchemaSetupInterface $setup, \Magento\Framework\Setup\ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();
        if (!$installer->tableExists('mpw_batterywarranty')) {
            $table = $installer->getConnection()->newTable(
                $installer->getTable('mpw_batterywarranty')
            )
                ->addColumn(
                    'id',
                    \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                    null,
                    [
                        'identity' => true,
                        'nullable' => false,
                        'primary'  => true,
                        'unsigned' => true,
                    ],
                    'Warranty ID'
                )
                ->addColumn(
                    'name',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    50,
                    ['nullable' => false],
                    'Name'
                )
                ->addColumn(
                    'tel',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    13,
                    ['nullable' => true],
                    'Telephone'
                )
                ->addColumn(
                    'email',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    50,
                    ['nullable' => false],
                    'Email'
                )
                ->addColumn(
                    'platform',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    25,
                    ['nullable' => false],
                    'Platform'
                )
                ->addColumn(
                    'order_date',
                    \Magento\Framework\DB\Ddl\Table::TYPE_DATE,
                    null,
                    ['nullable' => false],
                    'Order Date'
                )
                ->addColumn(
                    'created_at',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                    null,
                    ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
                    'Created At'
                )
                ->addColumn(
                    'order_num',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    20,
                    ['nullable' => false],
                    'Order Number'
                )
                ->addColumn(
                    'bike',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    125,
                    ['nullable' => false],
                    'Bike'
                )
                ->addColumn(
                    'code',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    16,
                    ['nullable' => false],
                    'Warranty COde'
                )
                ->setComment('Atom Battery Warranty Table');
            $installer->getConnection()->createTable($table);
        }
        $installer->endSetup();
    }
}
