<?php
/**
 * Copyright © 2015 Scommerce Mage. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Scommerce\GoogleTagManagerPro\Model\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Session\SessionManagerInterface;
use Scommerce\GoogleTagManagerPro\Helper\Data;

/**
 * Class OrderPlaceAfter
 * @package Scommerce\GoogleTagManagerPro\Model\Observer
 */
class OrderPlaceAfter implements ObserverInterface
{
    /**
     * @var Data
     */
    protected $_helper;

	/**
     * @var SessionManagerInterface
     */
	protected $_coreSession;

    /**
     * @param SessionManagerInterface $coresession
     * @param Data $helper
     */
    public function __construct(
        SessionManagerInterface $coresession,
        Data $helper
    ) {
        $this->_coreSession = $coresession;
        $this->_helper = $helper;
    }

    public function execute(EventObserver $observer)
    {
        $order = $observer->getEvent()->getOrder();
        $storeId = $order->getStoreId();
        if ($this->_helper->isEnhancedEcommerceEnabled($storeId)
            && $this->_helper->isEnabled($storeId)
            && $this->_helper->getSendAdminOrdersEnabled($storeId)
        ) {
            $products = array();

            if ($this->_helper->sendBaseData()):
                $orderCurrency 		= $order->getBaseCurrencyCode();
                $orderGrandTotal 	= $order->getBaseGrandTotal();
                $orderShippingTotal	= $order->getBaseShippingAmount();
                $orderTax			= $order->getBaseTaxAmount();
            else:
                $orderCurrency 		= $order->getOrderCurrencyCode();
                $orderGrandTotal 	= $order->getGrandTotal();
                $orderShippingTotal	= $order->getShippingAmount();
                $orderTax			= $order->getTaxAmount();
            endif;

            foreach ($order->getAllItems() as $item) {
                if ($item->getParentItemId()) continue;
                $products[] = array(
                    'name'	=> $item->getName(),
                    'id' 	=> $item->getSku(),
                    'price'	=> ($this->_helper->sendBaseData() == true ? $item->getBasePrice() : $item->getPrice()),
                    'brand' => $this->_helper->getBrand($item->getProduct()),
                    'category' => $this->_helper->getQuoteCategoryName($item),
                    'quantity' 	=> $item->getQtyOrdered()
                );
            }

            $response = array(
                'id'   			=> $order->getIncrementId(),
                'affiliation'   => $order->getAffiliation(),
                'revenue'   	=> $orderGrandTotal,
                'tax'   		=> $orderTax,
                'shipping'   	=> $orderShippingTotal,
                'coupon'   		=> $order->getCouponCode(),
                'storeId'   	=> $storeId,
                'products'  	=> $products,
            );

            $this->_coreSession->setOrderData(json_encode($response));
        }
    }

}