<?php

namespace Sinnis\HaynesAPI\Observer;

use Magento\Framework\Event\ObserverInterface;

class OrderObserver implements ObserverInterface
{

    /**
     * @var ObjectManagerInterface
     */
    protected $_objectManager;

    /**
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     */
    public function __construct(
        \Magento\Framework\ObjectManagerInterface $objectManager,
        \Magento\Quote\Model\QuoteFactory $quoteFactory,
        \Magento\Sales\Model\Order\Payment $payment,
        \Magento\Sales\Model\Order $order
    ) {
        $this->_objectManager = $objectManager;
        $this->order = $order;
    }

    /**
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        // Get the payment and order objects from the event
        $order = $observer->getEvent()->getPayment()->getOrder();

        // Loop through the order items to see if there are any Haynes products, break out and end the process when one is found
        foreach ($order->getAllItems() as $item){

            // Check for Haynes SKU prefix
            if(substr($item->getSku(), 0, strpos($item->getSku(), '-')) == 'HAY'){

                # Commented out for now as this section of code is causing an error - Error: Class "Zend\Log\Writer\Stream" not found #
                // Instantiate logger for debugging
                // $writer = new \Zend\Log\Writer\Stream(BP . '/var/log/debug.log');
                // $logger = new \Zend\Log\Logger();
                // $logger->addWriter($writer);

                // Extract data from the order and associated objects
                $order_data = $order->getData();
                $order_items = [];
                foreach ( $order->getAllItems() as $order_item ){
                    $order_items[] = $order_item->getData();
                }
                $shipping_address = $order->getShippingAddress()->getData();

                // $entry_url = 'http://api-proxy-2.local/api/magento';
                $entry_url = 'http://proxy.mpw-grp.co.uk/api/magento';
                // $entry_url = 'https://40932afe-2de0-4a04-a870-9fcfc4751395.mock.pstmn.io/api/magento';
                $order_id = $order->getIncrementId();
                $request_params = json_encode(array(
                                                    'order_data' => $order_data,
                                                    'order_items' => $order_items,
                                                    'shipping_address' => $shipping_address
                                                    ));

                try {
                    // Initialise curl
                    $ch = curl_init();

                    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                              "content-type: application/json",
                              "order-id: " . $order_id,
                              "token: _G5ZnZjA]J"
                            ));
                    curl_setopt($ch, CURLOPT_URL, $entry_url);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                    curl_setopt($ch, CURLOPT_HEADER, TRUE);
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $request_params);

                     // Make a call and receive the response
                    $response = curl_exec($ch);

                    //Close the connection
                    curl_close($ch);

                    // Log the response
                    $logger->info($response);

                } catch (Exception $exception) {

                    // Log caught exceptions
                    $logger->info($exception);

                }

                break;
            }
        }
    }
}
