<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Parts Finder for Magento 2
 */

namespace Amasty\Finder\Observer\Frontend;

use Amasty\Base\Model\Serializer;
use Amasty\Finder\Model\Repository\FinderRepository;
use Amasty\Finder\Model\ResourceModel\Finder\Collection;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\View\LayoutInterface;
use Magento\Store\Model\StoreManagerInterface;

class AddFinderAjax implements ObserverInterface
{
    /**
     * @var LayoutInterface
     */
    private $layout;

    /**
     * @var FinderRepository
     */
    private $finderRepository;

    /**
     * @var Serializer
     */
    private $serializer;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        LayoutInterface $layout,
        FinderRepository $finderRepository,
        Serializer $serializer,
        StoreManagerInterface $storeManager
    ) {
        $this->layout = $layout;
        $this->finderRepository = $finderRepository;
        $this->serializer = $serializer;
        $this->storeManager = $storeManager;
    }

    public function execute(Observer $observer): void
    {
        $data = $observer->getData('data');
        if (!$data) {
            return;
        }

        $responseData = $data->getData('responseData');
        if (!$responseData) {
            return;
        }

        $finders = [];
        foreach ($this->getAmfindersCollection($responseData) as $key => $finder) {
            $finders[$key] = $this->getBlockHtml('amasty.finder.' . $key);
        }

        $responseData['amfinders'] = $this->serializer->serialize($finders);
        $data->setData('responseData', $responseData);
    }

    private function getAmfindersCollection(array $responseData): Collection
    {
        $currentCategoryId = $responseData['currentCategoryId'] ?? null;

        if ($this->storeManager->getStore()->getRootCategoryId() == $currentCategoryId || empty($currentCategoryId)) {
            return $this->finderRepository->getFindersOnDefaultCategory();
        }

        return $this->finderRepository->getFindersCategory($currentCategoryId);
    }

    private function getBlockHtml(string $blockName): string
    {
        $amfinderBlock = $this->layout->getBlock($blockName);

        return $amfinderBlock ? $amfinderBlock->toHtml() : '';
    }
}
