define([
    'jquery'
], function ($) {
    'use strict';

    return function (widget) {
        $.widget('mage.amShopbyAjax', widget, {
            reloadHtml: function (data) {
                var amfinderSelector = '.amfinder-common-wrapper',
                    amastyCatalogTopnav = '.amasty-catalog-topnav';

                this._super(data);

                var amfinders = JSON.parse(data.amfinders),
                    amfindersHtml = '';

                if (Object.keys(amfinders).length) {
                    $.each(amfinders, function (index, amfinder) {
                        amfindersHtml += amfinder;
                    });

                    if (!$(amfinderSelector).length) {
                        $(amastyCatalogTopnav).before(amfindersHtml);
                    }
                } else {
                    $(amfinderSelector).remove();
                }
            }
        });

        return $.mage.amShopbyAjax;
    }
});
