# Magento 2 Banner Slider Extension FREE by Mageplaza

**[Banner slider for Magento 2](https://www.mageplaza.com/magento-2-banner-slider-extension/)** is a supportive marketing tool which allows store owners to display unlimited eye-catching banner sliders on their Ecommerce website. By this way, the extension helps draw customers' attention as well as optimize their experience, with a user-friendly interface. 

Magento 2 Banner Slider Module accordingly will help improve customer retention and prevent the site from being abandoned by customers. This actually will increase the rate of subscribers of the website. 

[![Latest Stable Version](https://poser.pugx.org/mageplaza/module-banner-slider/v/stable)](https://packagist.org/packages/mageplaza/module-banner-slider)
[![Total Downloads](https://poser.pugx.org/mageplaza/module-banner-slider/downloads)](https://packagist.org/packages/mageplaza/module-banner-slider)

**IMPORTANT NOTE:** This version of Mageplaza Banner Slider extension on Github is free as a contribution to the Magento community from Mageplaza. This package does not include the technical support. Should you need technical support for this extension, you will have to buy a license from Mageplaza. [Click here to buy](https://www.mageplaza.com/magento-2-banner-slider-extension/).

## 1. Documentation

- [Installation guide](https://www.mageplaza.com/install-magento-2-extension/)
- [User Guide](https://docs.mageplaza.com/banner-slider-m2/)
- [Get Support](https://github.com/mageplaza/magento-2-banner-slider/issues)
- [Download from our Live site](https://www.mageplaza.com/magento-2-banner-slider-extension/)
- [Contribute on Github](https://github.com/mageplaza/magento-2-banner-slider)



## 2. How to install Banner Slider in Magento 2

### ✓ Install via composer (recommend)

Run the following command in Magento 2 root folder:

With Social Proof (recommend):
```
composer require mageplaza/module-banner-slider avada/module-proofo
php bin/magento setup:upgrade
php bin/magento setup:static-content:deploy
```

Without Social Proof:
```
composer require mageplaza/module-banner-slider 
php bin/magento setup:upgrade
php bin/magento setup:static-content:deploy
```


### ✓ Install Package from Mageplaza


- Download the latest version at [Mageplaza Banner Slider for Magento 2](https://www.mageplaza.com/magento-2-banner-slider-extension/)
-  [Installation guide](https://www.mageplaza.com/install-magento-2-extension/)


## 3. FAQs

**Q: I got error: `Mageplaza_Core has been already defined`**

A: Read solution [Here](https://github.com/mageplaza/module-core/issues/3).

**Q: Can I set the Banner to any places on the store site?**

A: Absolutely yes, you can configure it easily by adding Banner Slider widget to any CMS Page of CMS Static Block.

**Q: Is there any animation effects for Banners movement?**

A: Yes, there are 9 optional animation effects for Banner Sliders displaying. You can select and flexible change it in the backend.

**Q: Does this extension support any available templates for banners?**

A: Yes. We support 4 available templates that you can use for customization. Please set Advanced Type and select the demo template. See more information [Here](https://docs.mageplaza.com/banner-slider-m2/index.html).

**Q: Can I create a Banner Slider Widget?**

A: Yes, you can create the widget by navigating to `Content > Elements > Widgets`, then set type as Banner Slider Widget and Design Theme. See more information [Here](https://docs.mageplaza.com/banner-slider-m2/index.html).



## 4. Highlight features of Magento 2 Banner Slider

### Unlimited Banners and Sliders

Banner Slider Extension helps store owners upload unlimited banners with ease. This tool supports multiple image formats as .ipg, .ipeg, .gif, and .png. The flexibility of banners and sliders location even can meet requirements of store owners with special marketing strategies. More amazing, the diversity in design, as well as the appearance of banners and sliders, can contribute to the professional performance of the store. And helps they achieve typical views from expectable customers. 

![Imgur](https://i.imgur.com/wis3Jr4.gif)

### Optional animation effects to show Slider

Animation effects can considerably better the Sliders' appearance, and make them appealing to customers. Banner Slider module by Mageplaza support 9 available slider effects including:

- Slider 
- Fade-out
- Rotate-out
- Flip-out
- Roll-out
- Zoom-out
- Slide-out-left
- Slide-out-right
- Light-speed-out

![Imgur](https://i.imgur.com/7hqW3oT.png)

### Easy to custom the Slider's design 

The store owner can swiftly design the banner sliders as their requirement. Besides the presentation effects, the extension also allows customizing various features of the slider such as:

- Width
- Height
- Infinity Loop
- Next/ Prev Buttons
- Dots Navigation 
- Lazy Loading Images
- Autoplay

![Imgur](https://i.imgur.com/FzbY5a8.png)

### Advanced Template Editor 

For website administrators who have certain knowledge and technical skills about coding, uploading images for Sliders can be quicker and easier than ever. You can input codes into the editor section, as the module supports advanced demo templates that can be edited via the backend editor.

Furthermore, this function allows admins to upload multiple images at the same time, by embedding their links to the editor. 

![Imgur](https://i.imgur.com/prIwSPn.gif)


### Flexibly located Banner Sliders  

The extension allows the store admin to set position for Sliders easily from the options list with various available positions on the site. The main positions including the product view page, product list page, homepage, header, and footer. Furthermore, another way to locate Banner Sliders is manually creating a widget and add to any CMS Page, or CMS Static Block of the site. The strategic location of Banner Sliders will play an indispensable role in raising the interest in customers' mind, as well as stimulate their purchasing behaviors.

![Imgur](https://i.imgur.com/Rsxm9Yf.png)

## 5. More features

#### Management grids

View and edit Banners easily in management grids.

#### URL in Banner 

Attach an URL to the Banner, and navigate to a new tab after clicking on. 

#### Slider visibility 

Enable Sliders' visibility to specific store views and specific customer groups.

#### Displaying time 

Set the amount of time to display the Slider.

#### Multi-device responsiveness

Banner Sliders can work well on multiple interfaces such as mobiles, desktops, tablets, and any other screen sizes.

#### Statistics report 

The extension will publish a report on Click and Impression data, which represents the possibility and effectiveness of Banner Sliders.


## 6. Full features of Banner Slider

### For store admins

#### General Configuration

- Enable/disable the module

#### Banner Configuration

- Add new Banners
- Identify the Banner
- Enable/disable the Banner
- Optional types of Banners: Image/Advanced (Template Editor)
- Insert an image as a Banner
- Edit/add images for Banners by Template Editor
- Add URL to a banner
- Enable/disable to redirect to a new tab after clicking on a Banner
- Manage/edit all Banners in a grids

#### Slider Configuration  

- Add new Sliders
- Enable/disable Sliders
- Select slider location in the optional positions list or by using a widget
- Set Sliders' visibility 
- Set amount of displaying time
- Set priority for particular Sliders
- Select Banners for the Slider
- Set animation effects 
- Enable/disable Responsive, Auto width, Auto height, Infinity Loop, Show Next/Prev Buttons, Show Dots Navigation, Lazy Loading Images, - Autoplay 

### For customers 

- Update the latest information about products and special promotions
- Interestingly experience the store site
- View banner sliders on multi-devices


## 7. Magento 2 Banner Slider User Guide

In this guide, I will show you how to insert A banner slider into Homepage of Magento 2 store.

### 7.1. Configuration

Login to the **Magento Admin**, navigate to `Store > Configuration > Mageplaza > Banner Sliders`

![Imgur](https://i.imgur.com/K5nb4vt.gif)

#### 7.1.1.  General

![Imgur](https://i.imgur.com/VZmykMx.png)

**Enable**: Select `Yes` to activate the module and No to disable it.

#### 7.1.2.  Slider Design Configuration

![Imgur](https://i.imgur.com/siwpSfu.png)

- **Responsive**: 

  - Select `No` to set the default number of displayed Banners (1 banner).
  
 ![Imgur](https://i.imgur.com/8lajdrX.png) 

  - Select `Yes` to configure number of displayed banners. You can customize **Screen size from** and **Number of items** in the **Max Items** field. 

For instance: Set **Screen size from** = 100, **Number of items** = 3, the frontend will be seen as:

![Imgur](https://i.imgur.com/ybmxctU.png)


- **Auto Width**: Select `Yes` to enable the **auto-width** function.

![Imgur](https://i.imgur.com/qhWt3y6.gif) 

`Note`: Use width style on elements to get the result you want. If using with infinity loop add option 'items' more than 1. It all depends on the width of your content.

- **Auto Height**: Select `Yes` to enable the **auto-height** function.


![Imgur](https://i.imgur.com/FWgPMxR.gif)

- **Infinity Loop**: Select `Yes` to display Slider again after the last Banner.

![Imgur](https://i.imgur.com/ufRzqUA.gif)

- **Show Next/Prev buttons**:

   - You can select `Yes` to display `Next/Prev` buttons on the frontend when they want to see the next Banners or see again the previous ones.
  - When customers click on `Next/Prev` buttons, the Slider will move Banners as their intent.
  

![Imgur](https://i.imgur.com/cB4FDtW.gif)

- **Show Dots Navigation**: Select `Yes` in this section to show dots that represent for the Sliders page number.

![Imgur](https://i.imgur.com/ERJEcPn.png)

- **Lazy Load Images**: Set `Yes` to enable lazy-load mode when showing Banners.

- **Autoplay**: Select `Yes` to set Banners on the Slider automatically move to the left, after a specific time. This time cycle can be configured in `Autoplay TimeOut`. In the next displayed fields:

![Imgur](https://i.imgur.com/O8owGau.gif)

- **Autoplay TimeOut**: Set the amount of time for Banners movement.
      

### 7.2. Manage Banner

How to Create New Banner

From the `Admin Panel`, navigate to `Content > Banner Sliders > Manage Banners`, in the right side, hit `Add New` button.

![Imgur](https://i.imgur.com/n3GviGy.gif)

#### 7.2.1. Banner Information

- Name: Set name for the Banner. This name will help the admin identify the Banner.
- Status: Set `Enable` to activate the Banner.
- Type: Select the type of Banner
  - **Type = Image**: In the following displayed fields:
    - **Upload Image**: Click on the Plus symbol to upload an image for the banner.
    - **Banner title**: Insert Banner title, which will be displayed on the frontend.
    - **URL**: Set the URL of the destination page, which the customer will be redirected to when clicking on the Banner.
    
  - **Type = advanced**: You can set images for Banners here. It is possible to upload multiple Banners at the same time. Demo Template fields will appear and you can select the following templates:
  
**Demo Template 1**

![Imgur](https://i.imgur.com/OLe56SQ.png)


**Demo Template 2**

![Imgur](https://i.imgur.com/E3MW2KY.png)


**Demo Template 3**


![Imgur](https://i.imgur.com/NgkZ2dX.png)


**Demo Template 4**

![Imgur](https://i.imgur.com/2g9UPnh.png)


**Demo Template 5**
    
![Imgur](https://i.imgur.com/2GknUV1.png)

`Note`: 
  - Click on **Load Template** button to display the image of the template.
  - Set **Show/ Hide Editor**: display code, or image of the template.
  - **Insert Image**: Insert image for the Banner (it is possible to add many images at the same time). You should add many images if changing **Show/ Hide Editor** to code format, it can be more feasible and prevent issues as well.
  
- **Open new tab after clicking**: 

  - Select `Yes`, your customer will be redirected to a new tab when clicking to one of the Banners.
  - Select `No`, it will automatically reload the page, the customer will be navigated to the destination page, but still in the previous tab.

- **Slider**: Select the Slider in which Banners will be displayed.


### 7.3. Manage Slider

How to Create New Slider

In the **Admin Panel**, navigate to `Content > Banner Sliders > Manage Slider`, in the right side, click on Add New button.

![Imgur](https://i.imgur.com/4DV8Nb9.png)

#### 7.3.1. General

**Slider Information**

- **Name**: The name of the Slider in this section just can be seen from the backend. It helps to identify the Slider among others.

![Imgur](https://i.imgur.com/dzznMVx.gif)


- **Status**: Set `Enable` to activate the Slider. This allows admin to see Banners easily and concisely.
- **Position**: Set the position to display Sliders on the frontend.

![Imgur](https://i.imgur.com/Ia6H6RN.png)

- **Store View**: Select Store View in which Slider will be displayed. For unselected Store Views, Slider will not show up.
- **Customer Groups**: Define the group of customers who can see the Slider.
- **Active from**: Set the date to start showing Slider. 
- **Active to**: Set the date to disable the Slider.
- **Priority**:
  - Insert priority level for Sliders. 
  - The higher priority rank is set, the higher priority to display that Slider. For instance, if priority set as 1, that Sliders will be displayed first.
  
**Snippet code**

For each Slider, it is possible to use **Widgets**, in order to set position to display.

#### 7.3.2. Banner

This section stores information about created Banner such as ID, Image, Name, Status, Type, Position. Here you can select an appropriate banner to show on Sliders.

![Imgur](https://i.imgur.com/NMIdA68.png)

#### 7.3.3. Design

![Imgur](https://i.imgur.com/AXC7oNW.gif)

- **Animation Effect**: Set effect to show Sliders:

![Imgur](https://i.imgur.com/NIkXfx9.png)

  - **No effect** 

![Imgur](https://i.imgur.com/W1RggSP.gif)

  - **FadeOut**
  
![Imgur](https://i.imgur.com/W1CKh3y.gif)
  
  - **RotateOut**

![Imgur](https://i.imgur.com/EStFpaY.gif)

  - **FlipOut**

![Imgur](https://i.imgur.com/agefavd.gif)

  - **RollOut**

![Imgur](https://i.imgur.com/y8TNsJ9.gif)

  - **ZoomOut**

![Imgur](https://i.imgur.com/d90m6Jd.gif)

  - **SlideOutLeft**

![Imgur](https://i.imgur.com/csBFNtd.gif)

  - **SlideOutRight**
  
![Imgur](https://i.imgur.com/BfPJOPR.gif)

  - **LightSpeedOut**

![Imgur](https://i.imgur.com/6H01RnZ.gif)

- **Manually Design**: Choose the design data from:

  - Set `Use configuration`: Below fields will be hidden and data will be taken from the configuration
  - Set `Yes` to display customizable design for your Sliders. The design function is the same as in **Slider Design Configuration**, you can refer to the instruction that has been introduced above.  
  
  
### 7.4. Widgets

Besides already available positions, you can get the Banner Slider to appear wherever on the website. To create a Widget, you can do as following:

- **Step 1**: In the admin panel, navigate to `Content > Elements > Widgets`, select `Add Widget`
- **Step 2**: In the **Settings** section, set:  

  - `Type = Banner Slider widget`
  - `Design Theme = Magento Luma`
  
Click on `Continue` to move to the next step.

![Imgur](https://i.imgur.com/DEcxIKT.png)

- **Step 3**: Insert the required information to **Storefront Properties**. 

<img src="https://i.imgur.com/19z4R2T.png" alt="Insert the required information" />

- **Step 4**: Select position to show the Slider.

![Imgur](https://i.imgur.com/ECiIrzO.png)

- **Step 5**: Choose the Slider which you want to display.

![Imgur](https://i.imgur.com/K9IP0zC.png)

- **Step 6**: Click on `Save` button to save the configuration, then check how it works on the frontend.

**People also search:**
- magento 2 slider
- mageplaza banner slider
- banner slider magento 2
- magento 2 slider extension
- magento 2 banner slider extension free
- magento 2 slider module
- slider for magento 2
- magento 2 slider extension free
- magento 2 banner module
- magento 2 slider widget
- how to add slider in magento 2 home page
- magento 2 homepage slider


**Other free extension on Github**
- [Magento 2 Seo Module](https://github.com/mageplaza/magento-2-seo)
- [Magento 2 Security Suite](https://github.com/mageplaza/magento-2-security)
- [Magento 2 Maps extension](https://github.com/mageplaza/magento-2-google-maps)
- [Magento 2 ReCaptcha extension](https://github.com/mageplaza/magento-2-google-recaptcha)
- [Magento 2 social login module](https://github.com/mageplaza/magento-2-social-login)
- [Magento 2 blog extension](https://github.com/mageplaza/magento-2-blog)
- [Magento 2 Layered Navigation](https://github.com/mageplaza/magento-2-ajax-layered-navigation)
- [Magento 2 security suite](https://github.com/mageplaza/magento-2-security)


**Get more [Magento 2 extensions on Marketplace](https://marketplace.magento.com/partner/Mageplaza):**
- [M2 Reward Points](https://marketplace.magento.com/mageplaza-module-reward-points.html)
- [M2 Affiliate Module](https://marketplace.magento.com/mageplaza-module-affiliate.html)
- [M2 Product Feed](https://marketplace.magento.com/mageplaza-module-product-feed.html)
- [M2 Custom Order Number](https://marketplace.magento.com/mageplaza-module-custom-order-number.html)
- [M2 Multiple Coupons](https://marketplace.magento.com/mageplaza-module-multiple-coupons.html)
- [M2 Import Export CMS](https://marketplace.magento.com/mageplaza-module-import-export-cms.html)
- [Magento 2 Shipping Restrictions](https://marketplace.magento.com/mageplaza-module-shipping-restriction.html)
- [Magento 2 Multiple Coupons](https://marketplace.magento.com/mageplaza-module-multiple-coupons.html)
- [Magento 2 Order Attributes](https://marketplace.magento.com/mageplaza-module-order-attributes.html)
- [Magento 2 Barcode](https://marketplace.magento.com/mageplaza-module-barcode.html)
