<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-optimize
 * @version   2.1.13
 * @copyright Copyright (C) 2025 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\OptimizeImage\Plugin;

use Mirasvit\Core\Service\SerializeService;
use Mirasvit\OptimizeImage\Model\ConfigProvider;
use Mirasvit\OptimizeImage\Service\WebpService;

/** @see \Magento\Catalog\Block\Product\View\Gallery */
class ReplaceWebpInProductGalleryPlugin
{
    protected $webpService;

    protected $configProvider;

    protected $processedImages = [];

    public function __construct(
        WebpService $webpService,
        ConfigProvider $configProvider
    )  {
        $this->webpService    = $webpService;
        $this->configProvider = $configProvider;
    }

    public function afterGetGalleryImagesJson($subject, string $result): string
    {
        if (!$this->configProvider->isWebpEnabled()) {
            return $result;
        }

        $imagesConfig = SerializeService::decode($result);

        if (!is_array($imagesConfig)) {
            return $result;
        }

        return SerializeService::encode($this->processImagesConfig($imagesConfig));
    }

    protected function processImagesConfig(array $imagesConfig): array
    {
        $imgKeys = ['thumb', 'img', 'full'];

        foreach ($imagesConfig as $key => $config) {
            foreach ($config as $k => $v) {
                if (!in_array($k, $imgKeys)) {
                    continue;
                }

                if (!isset($this->processedImages[$v])) {
                    $this->processedImages[$v] = $this->webpService->getImageWebpUrl($v);
                }

                $config[$k] = $this->processedImages[$v];
            }

            $imagesConfig[$key] = $config;
        }

        return $imagesConfig;
    }
}
