<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-optimize
 * @version   2.1.13
 * @copyright Copyright (C) 2025 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\OptimizeImage\Service;


use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem;
use Mirasvit\OptimizeImage\Model\ConfigProvider;
use Mirasvit\OptimizeImage\Repository\FileRepository;

class CleanupService
{
    private $filesystem;

    private $fileRepository;

    private $configProvider;

    public function __construct(
        Filesystem $filesystem,
        FileRepository $fileRepository,
        ConfigProvider $configProvider
    ) {
        $this->filesystem     = $filesystem;
        $this->fileRepository = $fileRepository;
        $this->configProvider = $configProvider;
    }

    public function deleteGeneratedImages(string $absolutePath)
    {
        $file = $this->fileRepository->getByRelativePath(
            $this->configProvider->getRelativePath($absolutePath)
        );

        if (!$file) {
            return;
        }

        $directoryWrite = $this->filesystem->getDirectoryWrite(DirectoryList::ROOT);

        if ($optimizedPath = $file->getOptimizedPath()) {
            $directoryWrite->delete($directoryWrite->getAbsolutePath($optimizedPath));
        }

        if ($webpPath = $file->getWebpPath()) {
            $directoryWrite->delete($directoryWrite->getAbsolutePath($webpPath));
        }

        $this->fileRepository->delete($file);
    }
}
