/*eslint-disable */
define([
    'jquery',
    'knockout',
    'mage/translate',
    'Magento_Customer/js/customer-data',
    'Mirasvit_Search/js/highlight',
    'Mirasvit_SearchAutocomplete/js/in-page/PageView'
], function (_jquery, _knockout, _t, _customerData, _highlight, _PageView) {
    'use strict';

    var Injection = function Injection(input, config) {
        var _this = this;

        this.initView = function () {
            var selector = "#mst-searchautocomplete-in-page";
            if ((0, _jquery)(selector).length > 0) {
                return;
            }
            var wrapper = (0, _jquery)("#mstInPage__page").html();
            (0, _jquery)("body").append(wrapper);
            var node = (0, _jquery)(selector)[0];
            _knockout.applyBindings(_this.pageView, node);
        };

        this.onFocus = function () {
            _this.initView();
            _this.pageView.visible(true);
            _this.pageView.searchQuery(_this.$input.val() + "");
        };

        this.$input = (0, _jquery)(input);
        this.pageView = new _PageView.PageView(config);
        this.$input.on("click focus", this.onFocus);

        _knockout.bindingHandlers.highlight = {
            init: function init(element, valueAccessor, allBindings, viewModel, bindingContext) {
                (0, _highlight)(element, bindingContext.$parents[2].result().query, "mstInPage__highlight");
            }
        };

        _knockout.bindingHandlers.processStockStatus = {
            init: function init(element, valueAccessor, allBindings, viewModel, bindingContext) {
                var value = _jquery(element).text();
                if (value == 2) {
                    value = _t('In stock');
                    _jquery(element).addClass('inStock');
                } else {
                    value = _t('Out Of Stock');
                    _jquery(element).addClass('outOfStock');
                }

                _jquery(element).text(value);
            }
        };

        _knockout.bindingHandlers.mstAddToCart = {
            init: function init(element, valueAccessor, allBindings, viewModel, bindingContext) {
                _jquery(element).click(function (event) {
                    const linkToCart = _jquery(element).attr('_href');

                    if (config.isAjaxCartButton) {
                        this.xhr = _jquery.ajax({
                            url:      linkToCart,
                            dataType: 'json',
                            type:     'GET',
                            success:  function (data) {
                                let message = '<div class="to_cart_message ' + (data.success ? 'success' : 'error') + '">' + data.message + '</div>';

                                // reload cart
                                let sections = ['cart'];
                                _customerData.invalidate(sections);
                                _customerData.reload(sections, true);

                                _jquery(element).closest('.mst__product-meta').prepend(message);
                                setTimeout(function () {
                                    _jquery(element).closest('.mst__product-meta').find('.to_cart_message').remove();
                                }, 5000);
                            }.bind(this)
                        });
                    } else {
                        _jquery(element).attr('href', linkToCart).trigger('click');
                    }
                });
            }
        };
    };

    return Injection;
});
//# sourceMappingURL=in-page.js.map
