import { IndexResult, Result } from "../types"
import _ from "underscore"
import ko from "knockout"

interface Props {
    result: KnockoutObservable<Result>
    activeIndex: KnockoutObservable<string>
}

export class ItemListView {
    props: Props

    items: KnockoutObservableArray<object>

    isMisspell: KnockoutObservable<boolean>

    constructor(props: Props) {
        this.props = props
        this.items = ko.observableArray([])
        this.isMisspell = ko.observable(false)
        this.textMisspell = ko.observable()
        this.textCorrected = ko.observable()

        this.setItems(props.result().indexes, props.activeIndex())

        props.result.subscribe(result => this.setItems(result.indexes, props.activeIndex()))
        props.activeIndex.subscribe(index => this.setItems(props.result().indexes, index))
    }

    setItems = (indexes: IndexResult[], indexIdentifier: string) => {
        let updated = false

        _.each(indexes, idx => {
            if (idx.identifier === indexIdentifier) {
                this.items(idx.items)
                this.isMisspell(idx.isMisspell)
                this.textMisspell(idx.textMisspell)
                this.textCorrected(idx.textCorrected)
                updated = true
            }
        })

        !updated && this.items([]) && this.isMisspell(false) && this.textMisspell() && this.textCorrected()
    }
}
