<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Cluster;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class GetWeightedRouting extends AbstractEndpoint
{
    protected $attribute;

    public function getURI(): string
    {
        $attribute = $this->attribute ?? null;
        if (isset($attribute)) {
            return "/_cluster/routing/awareness/$attribute/weights";
        }
        throw new RuntimeException('Missing parameter for the endpoint cluster.get_weighted_routing');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function setAttribute($attribute): static
    {
        if (is_null($attribute)) {
            return $this;
        }
        $this->attribute = $attribute;

        return $this;
    }
}
