<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Namespaces;

use OpenSearch\Endpoints\Security\Authinfo;
use OpenSearch\Endpoints\Security\Authtoken;
use OpenSearch\Endpoints\Security\Cache;
use OpenSearch\Endpoints\Security\ChangePassword;
use OpenSearch\Endpoints\Security\ConfigUpgradeCheck;
use OpenSearch\Endpoints\Security\ConfigUpgradePerform;
use OpenSearch\Endpoints\Security\CreateActionGroup;
use OpenSearch\Endpoints\Security\CreateAllowlist;
use OpenSearch\Endpoints\Security\CreateRole;
use OpenSearch\Endpoints\Security\CreateRoleMapping;
use OpenSearch\Endpoints\Security\CreateTenant;
use OpenSearch\Endpoints\Security\CreateUpdateTenancyConfig;
use OpenSearch\Endpoints\Security\CreateUser;
use OpenSearch\Endpoints\Security\CreateUserLegacy;
use OpenSearch\Endpoints\Security\DeleteActionGroup;
use OpenSearch\Endpoints\Security\DeleteDistinguishedName;
use OpenSearch\Endpoints\Security\DeleteRole;
use OpenSearch\Endpoints\Security\DeleteRoleMapping;
use OpenSearch\Endpoints\Security\DeleteTenant;
use OpenSearch\Endpoints\Security\DeleteUser;
use OpenSearch\Endpoints\Security\DeleteUserLegacy;
use OpenSearch\Endpoints\Security\FlushCache;
use OpenSearch\Endpoints\Security\GenerateOboToken;
use OpenSearch\Endpoints\Security\GenerateUserToken;
use OpenSearch\Endpoints\Security\GenerateUserTokenLegacy;
use OpenSearch\Endpoints\Security\GetAccountDetails;
use OpenSearch\Endpoints\Security\GetActionGroup;
use OpenSearch\Endpoints\Security\GetActionGroups;
use OpenSearch\Endpoints\Security\GetAllCertificates;
use OpenSearch\Endpoints\Security\GetAllowlist;
use OpenSearch\Endpoints\Security\GetAuditConfiguration;
use OpenSearch\Endpoints\Security\GetCertificates;
use OpenSearch\Endpoints\Security\GetConfiguration;
use OpenSearch\Endpoints\Security\GetDashboardsInfo;
use OpenSearch\Endpoints\Security\GetDistinguishedName;
use OpenSearch\Endpoints\Security\GetDistinguishedNames;
use OpenSearch\Endpoints\Security\GetNodeCertificates;
use OpenSearch\Endpoints\Security\GetPermissionsInfo;
use OpenSearch\Endpoints\Security\GetRole;
use OpenSearch\Endpoints\Security\GetRoleMapping;
use OpenSearch\Endpoints\Security\GetRoleMappings;
use OpenSearch\Endpoints\Security\GetRoles;
use OpenSearch\Endpoints\Security\GetSslinfo;
use OpenSearch\Endpoints\Security\GetTenancyConfig;
use OpenSearch\Endpoints\Security\GetTenant;
use OpenSearch\Endpoints\Security\GetTenants;
use OpenSearch\Endpoints\Security\GetUser;
use OpenSearch\Endpoints\Security\GetUserLegacy;
use OpenSearch\Endpoints\Security\GetUsers;
use OpenSearch\Endpoints\Security\GetUsersLegacy;
use OpenSearch\Endpoints\Security\Health;
use OpenSearch\Endpoints\Security\Migrate;
use OpenSearch\Endpoints\Security\PatchActionGroup;
use OpenSearch\Endpoints\Security\PatchActionGroups;
use OpenSearch\Endpoints\Security\PatchAllowlist;
use OpenSearch\Endpoints\Security\PatchAuditConfiguration;
use OpenSearch\Endpoints\Security\PatchConfiguration;
use OpenSearch\Endpoints\Security\PatchDistinguishedName;
use OpenSearch\Endpoints\Security\PatchDistinguishedNames;
use OpenSearch\Endpoints\Security\PatchRole;
use OpenSearch\Endpoints\Security\PatchRoleMapping;
use OpenSearch\Endpoints\Security\PatchRoleMappings;
use OpenSearch\Endpoints\Security\PatchRoles;
use OpenSearch\Endpoints\Security\PatchTenant;
use OpenSearch\Endpoints\Security\PatchTenants;
use OpenSearch\Endpoints\Security\PatchUser;
use OpenSearch\Endpoints\Security\PatchUsers;
use OpenSearch\Endpoints\Security\PostDashboardsInfo;
use OpenSearch\Endpoints\Security\ReloadHttpCertificates;
use OpenSearch\Endpoints\Security\ReloadTransportCertificates;
use OpenSearch\Endpoints\Security\TenantInfo;
use OpenSearch\Endpoints\Security\UpdateAuditConfiguration;
use OpenSearch\Endpoints\Security\UpdateConfiguration;
use OpenSearch\Endpoints\Security\UpdateDistinguishedName;
use OpenSearch\Endpoints\Security\Validate;
use OpenSearch\Endpoints\Security\WhoAmI;
use OpenSearch\Endpoints\Security\WhoAmIProtected;

/**
 * Class SecurityNamespace
 *
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class SecurityNamespace extends AbstractNamespace
{
    /**
     * Returns the authentication information.
     *
     * $params['auth_type']   = (string) The type of current authentication request.
     * $params['verbose']     = (boolean) Indicates whether a verbose response should be returned.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function authinfo(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(Authinfo::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns the authorization token.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function authtoken(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(Authtoken::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Not supported for cache API.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function cache(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(Cache::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Check whether or not an upgrade can be performed and what resources can be updated.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function configUpgradeCheck(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(ConfigUpgradeCheck::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Helps cluster operator upgrade missing defaults and stale default definitions.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function configUpgradePerform(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(ConfigUpgradePerform::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Creates or replaces the permitted APIs. Accessible using Super Admin certificate or REST API permission.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createAllowlist(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(CreateAllowlist::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Creates or replaces the multi-tenancy configuration. Only accessible to admins and users with REST API permissions.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createUpdateTenancyConfig(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(CreateUpdateTenancyConfig::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Creates or replaces the specified user. Legacy API.
     *
     * $params['username']    = (string) The name of the user to be created. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createUserLegacy(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(CreateUserLegacy::class);
        $endpoint->setParams($params);
        $endpoint->setUsername($username);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Delete a specified action group.
     *
     * $params['action_group'] = (string) The name of the action group to delete. (Required)
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']        = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteActionGroup(array $params = [])
    {
        $action_group = $this->extractArgument($params, 'action_group');

        $endpoint = $this->endpointFactory->getEndpoint(DeleteActionGroup::class);
        $endpoint->setParams($params);
        $endpoint->setActionGroup($action_group);

        return $this->performRequest($endpoint);
    }

    /**
     * Deletes all distinguished names in the specified cluster or node allow list. Only accessible to super-admins and with rest-api permissions when enabled.
     *
     * $params['cluster_name'] = (string) The cluster-name to delete from list of distinguished names. (Required)
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']        = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteDistinguishedName(array $params = [])
    {
        $cluster_name = $this->extractArgument($params, 'cluster_name');

        $endpoint = $this->endpointFactory->getEndpoint(DeleteDistinguishedName::class);
        $endpoint->setParams($params);
        $endpoint->setClusterName($cluster_name);

        return $this->performRequest($endpoint);
    }

    /**
     * Delete the specified role.
     *
     * $params['role']        = (string) The name of the role to delete. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteRole(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');

        $endpoint = $this->endpointFactory->getEndpoint(DeleteRole::class);
        $endpoint->setParams($params);
        $endpoint->setRole($role);

        return $this->performRequest($endpoint);
    }

    /**
     * Deletes the specified role mapping.
     *
     * $params['role']        = (string) The name of the role whose mapping needs to delete. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteRoleMapping(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');

        $endpoint = $this->endpointFactory->getEndpoint(DeleteRoleMapping::class);
        $endpoint->setParams($params);
        $endpoint->setRole($role);

        return $this->performRequest($endpoint);
    }

    /**
     * Delete the specified tenant.
     *
     * $params['tenant']      = (string) The name of the tenant to delete. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteTenant(array $params = [])
    {
        $tenant = $this->extractArgument($params, 'tenant');

        $endpoint = $this->endpointFactory->getEndpoint(DeleteTenant::class);
        $endpoint->setParams($params);
        $endpoint->setTenant($tenant);

        return $this->performRequest($endpoint);
    }

    /**
     * Delete the specified user.
     *
     * $params['username']    = (string) The name of the user to delete. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteUser(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');

        $endpoint = $this->endpointFactory->getEndpoint(DeleteUser::class);
        $endpoint->setParams($params);
        $endpoint->setUsername($username);

        return $this->performRequest($endpoint);
    }

    /**
     * Delete the specified user. Legacy API.
     *
     * $params['username']    = (string) The name of the user to delete. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteUserLegacy(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');

        $endpoint = $this->endpointFactory->getEndpoint(DeleteUserLegacy::class);
        $endpoint->setParams($params);
        $endpoint->setUsername($username);

        return $this->performRequest($endpoint);
    }

    /**
     * Flushes the Security plugin user, authentication, and authorization cache.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function flushCache(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(FlushCache::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Generates On-Behalf-Of token for the current user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function generateOboToken(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(GenerateOboToken::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Generates authorization token for the given user.
     *
     * $params['username']    = (string) The name of the user for whom an auth token is to be vended. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function generateUserToken(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');

        $endpoint = $this->endpointFactory->getEndpoint(GenerateUserToken::class);
        $endpoint->setParams($params);
        $endpoint->setUsername($username);

        return $this->performRequest($endpoint);
    }

    /**
     * Generates authorization token for the given user. Legacy API. Not Implemented.
     *
     * $params['username']    = (string) The name of the user for whom an auth token is to be vended. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function generateUserTokenLegacy(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');

        $endpoint = $this->endpointFactory->getEndpoint(GenerateUserTokenLegacy::class);
        $endpoint->setParams($params);
        $endpoint->setUsername($username);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns account details for the current user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getAccountDetails(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(GetAccountDetails::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves one action group.
     *
     * $params['action_group'] = (string) The name of the action group to retrieve. (Required)
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']        = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getActionGroup(array $params = [])
    {
        $action_group = $this->extractArgument($params, 'action_group');

        $endpoint = $this->endpointFactory->getEndpoint(GetActionGroup::class);
        $endpoint->setParams($params);
        $endpoint->setActionGroup($action_group);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves the cluster security certificates.
     *
     * $params['cert_type']   = (string) The type of certificates (HTTP, TRANSPORT, ALL) to retrieve from all nodes.
     * $params['timeout']     = (string) The maximum duration, in seconds, to be spent to retrieve certificates from all nodes.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getAllCertificates(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(GetAllCertificates::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves the current list of allowed API accessible to normal user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getAllowlist(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(GetAllowlist::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves the audit configuration.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getAuditConfiguration(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(GetAuditConfiguration::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves the cluster security certificates.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getCertificates(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(GetCertificates::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Returns the current Security plugin configuration in JSON format.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getConfiguration(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(GetConfiguration::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves the current security-dashboards plugin configuration.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getDashboardsInfo(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(GetDashboardsInfo::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves distinguished names. Only accessible to super-admins and with rest-api permissions when enabled.
     *
     * $params['cluster_name'] = (string) The cluster-name to retrieve nodes DN setting for. (Required)
     * $params['show_all']     = (boolean) A Boolean flag to include/exclude static nodes DN from final result.
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']        = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getDistinguishedName(array $params = [])
    {
        $cluster_name = $this->extractArgument($params, 'cluster_name');

        $endpoint = $this->endpointFactory->getEndpoint(GetDistinguishedName::class);
        $endpoint->setParams($params);
        $endpoint->setClusterName($cluster_name);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves the given node's security certificates.
     *
     * $params['node_id']     = (string) The full-id of the node to retrieve certificates.
     * $params['cert_type']   = (string) The type of certificates (HTTP, TRANSPORT, ALL) to retrieve for a node.
     * $params['timeout']     = (string) The maximum duration, in seconds, to be spent to retrieve a node's certificates.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getNodeCertificates(array $params = [])
    {
        $node_id = $this->extractArgument($params, 'node_id');

        $endpoint = $this->endpointFactory->getEndpoint(GetNodeCertificates::class);
        $endpoint->setParams($params);
        $endpoint->setNodeId($node_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Gets the evaluated REST API permissions for the currently logged in user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getPermissionsInfo(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(GetPermissionsInfo::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves one role.
     *
     * $params['role']        = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getRole(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');

        $endpoint = $this->endpointFactory->getEndpoint(GetRole::class);
        $endpoint->setParams($params);
        $endpoint->setRole($role);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves one role mapping.
     *
     * $params['role']        = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getRoleMapping(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');

        $endpoint = $this->endpointFactory->getEndpoint(GetRoleMapping::class);
        $endpoint->setParams($params);
        $endpoint->setRole($role);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves the SSL configuration information.
     *
     * $params['show_dn']     = (Array) A Boolean flag to indicate whether all domain names should be returned.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getSslinfo(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(GetSslinfo::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves multi-tenancy configuration. Only accessible to admins and users with REST API permissions.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getTenancyConfig(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(GetTenancyConfig::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves one tenant.
     *
     * $params['tenant']      = (string) The name of the tenant to retrieve. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getTenant(array $params = [])
    {
        $tenant = $this->extractArgument($params, 'tenant');

        $endpoint = $this->endpointFactory->getEndpoint(GetTenant::class);
        $endpoint->setParams($params);
        $endpoint->setTenant($tenant);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieve one internal user.
     *
     * $params['username']    = (string) The name of the user to retrieve. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getUser(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');

        $endpoint = $this->endpointFactory->getEndpoint(GetUser::class);
        $endpoint->setParams($params);
        $endpoint->setUsername($username);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieve one user. Legacy API.
     *
     * $params['username']    = (string) The name of the user to retrieve. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getUserLegacy(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');

        $endpoint = $this->endpointFactory->getEndpoint(GetUserLegacy::class);
        $endpoint->setParams($params);
        $endpoint->setUsername($username);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieve all internal users. Legacy API.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getUsersLegacy(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(GetUsersLegacy::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Checks to see if the Security plugin is up and running.
     *
     * $params['mode']        = (string) A flag to indicate whether service should consider security-plugin's status before returning health response. `strict` mode indicates service should check Security plugin status.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function health(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(Health::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Migrates security configuration from v6 to v7.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function migrate(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(Migrate::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Updates individual attributes of an action group.
     *
     * $params['action_group'] = (string) The name of the action group to update. (Required)
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']        = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchActionGroup(array $params = [])
    {
        $action_group = $this->extractArgument($params, 'action_group');
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PatchActionGroup::class);
        $endpoint->setParams($params);
        $endpoint->setActionGroup($action_group);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Updates the current list of allowed API accessible to normal user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchAllowlist(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PatchAllowlist::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * A PATCH call is used to update specified fields in the audit configuration.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchAuditConfiguration(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PatchAuditConfiguration::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * A `PATCH` call is used to update the existing configuration using the REST API. Only accessible by admins and users with REST API access and only when put or patch is enabled.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchConfiguration(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PatchConfiguration::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Updates a distinguished cluster name for a specific cluster. Only accessible to super-admins and with rest-api permissions when enabled.
     *
     * $params['cluster_name'] = (string) The cluster name to update `nodesDn` value. (Required)
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']        = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchDistinguishedName(array $params = [])
    {
        $cluster_name = $this->extractArgument($params, 'cluster_name');
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PatchDistinguishedName::class);
        $endpoint->setParams($params);
        $endpoint->setClusterName($cluster_name);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Bulk update of distinguished names. Only accessible to super-admins and with rest-api permissions when enabled.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchDistinguishedNames(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PatchDistinguishedNames::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Updates individual attributes of a role.
     *
     * $params['role']        = (string) The name of the role to update. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchRole(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PatchRole::class);
        $endpoint->setParams($params);
        $endpoint->setRole($role);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Updates individual attributes of a role mapping.
     *
     * $params['role']        = (string) The name of the role to update role-mapping for. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchRoleMapping(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PatchRoleMapping::class);
        $endpoint->setParams($params);
        $endpoint->setRole($role);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Add, delete, or modify a single tenant.
     *
     * $params['tenant']      = (string) The name of the tenant to update. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchTenant(array $params = [])
    {
        $tenant = $this->extractArgument($params, 'tenant');
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PatchTenant::class);
        $endpoint->setParams($params);
        $endpoint->setTenant($tenant);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Updates individual attributes of an internal user.
     *
     * $params['username']    = (string) The name of the user to update. (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchUser(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(PatchUser::class);
        $endpoint->setParams($params);
        $endpoint->setUsername($username);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Updates the current security-dashboards plugin configuration.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function postDashboardsInfo(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(PostDashboardsInfo::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Reload HTTP layer communication certificates.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function reloadHttpCertificates(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(ReloadHttpCertificates::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Reload Transport layer communication certificates.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function reloadTransportCertificates(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(ReloadTransportCertificates::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Retrieves the tenant names if any exist. Only accessible to super admins or kibanaserver user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function tenantInfo(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(TenantInfo::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Updates the audit configuration.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function updateAuditConfiguration(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(UpdateAuditConfiguration::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Adds or updates the existing configuration using the REST API. Only accessible by admins and users with REST API access and only when put or patch is enabled.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function updateConfiguration(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(UpdateConfiguration::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Adds or updates the specified distinguished names in the cluster or node allow list. Only accessible to super-admins and with rest-api permissions when enabled.
     *
     * $params['cluster_name'] = (string) The cluster-name to create/update `nodesDn` value for. (Required)
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']        = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function updateDistinguishedName(array $params = [])
    {
        $cluster_name = $this->extractArgument($params, 'cluster_name');
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(UpdateDistinguishedName::class);
        $endpoint->setParams($params);
        $endpoint->setClusterName($cluster_name);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Checks whether the v6 security configuration is valid and ready to be migrated to v7.
     *
     * $params['accept_invalid'] = (boolean) A Boolean flag to indicate whether invalid v6 configuration should be allowed.
     * $params['pretty']         = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']          = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace']    = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']         = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']    = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function validate(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(Validate::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Gets the user identity related information for currently logged in user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function whoAmI(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(WhoAmI::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Gets the user identity related information for currently logged in user. User needs to have access to this endpoint when authorization at REST layer is enabled.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human readable values for statistics. (Default = true)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Used to reduce the response. This parameter takes a comma-separated list of filters. It supports using wildcards to match any field or part of a field’s name. You can also exclude fields with "-".
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function whoAmIProtected(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(WhoAmIProtected::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Changes the password for the current user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     * $params['current_password']   = (string) The current password
     * $params['password']           = (string) New password
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function changePassword(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = [
                'current_password' => $this->extractArgument($params, 'current_password'),
                'password' => $this->extractArgument($params, 'password'),
            ];
        }

        $endpoint = $this->endpointFactory->getEndpoint(ChangePassword::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates or replaces the specified action group.
     *
     * $params['action_group'] = (string) The name of the action group to create or replace. (Required)
     * $params['allowed_actions']    = (array) list of allowed actions
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']        = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createActionGroup(array $params = [])
    {
        $action_group = $this->extractArgument($params, 'action_group');
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = [
                'allowed_actions' => $this->extractArgument($params, 'allowed_actions'),
            ];
        }

        $endpoint = $this->endpointFactory->getEndpoint(CreateActionGroup::class);
        $endpoint->setParams($params);
        $endpoint->setActionGroup($action_group);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates or replaces the specified role mapping.
     *
     * $params['role']        = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     * $params['backend_roles']  = (array)
     * $params['hosts']          = (array)
     * $params['users']          = (array)
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createRoleMapping(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = array_filter([
                'backend_roles' => $this->extractArgument($params, 'backend_roles'),
                'hosts' => $this->extractArgument($params, 'hosts'),
                'users' => $this->extractArgument($params, 'users'),
            ]);
        }

        $endpoint = $this->endpointFactory->getEndpoint(CreateRoleMapping::class);
        $endpoint->setParams($params);
        $endpoint->setRole($role);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates or replaces the specified role.
     *
     * $params['role']        = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     * $params['cluster_permissions']  = (array)
     * $params['index_permissions']    = (array)
     * $params['tenant_permissions']   = (array)
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createRole(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = array_filter([
                'cluster_permissions' => $this->extractArgument($params, 'cluster_permissions'),
                'index_permissions' => $this->extractArgument($params, 'index_permissions'),
                'tenant_permissions' => $this->extractArgument($params, 'tenant_permissions'),
            ]);
        }

        $endpoint = $this->endpointFactory->getEndpoint(CreateRole::class);
        $endpoint->setParams($params);
        $endpoint->setRole($role);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates or replaces the specified tenant.
     *
     * $params['tenant']      = (string) The name of the tenant to create
     * $params['description'] = (string) Description of the tenant
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createTenant(array $params = [])
    {
        $tenant = $this->extractArgument($params, 'tenant');
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = [
                'description' => $this->extractArgument($params, 'description'),
            ];
        }

        $endpoint = $this->endpointFactory->getEndpoint(CreateTenant::class);
        $endpoint->setParams($params);
        $endpoint->setTenant($tenant);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates or replaces the specified user.
     *
     * $params['username']    = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     * $params['password']                   = (string)
     * $params['opendistro_security_roles']  = (array)
     * $params['backend_roles']              = (array)
     * $params['attributes']                 = (array)
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createUser(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = array_filter([
                'password' => $this->extractArgument($params, 'password'),
                'opendistro_security_roles' => $this->extractArgument($params, 'opendistro_security_roles'),
                'backend_roles' => $this->extractArgument($params, 'backend_roles'),
                'attributes' => $this->extractArgument($params, 'attributes'),
            ]);
        }

        $endpoint = $this->endpointFactory->getEndpoint(CreateUser::class);
        $endpoint->setParams($params);
        $endpoint->setUsername($username);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Proxy function to deleteDistinguishedNames() to prevent BC break.
     * This API will be removed in a future version. Use 'deleteDistinguishedName' API instead.
     */
    public function deleteDistinguishedNames(array $params = [])
    {
        return $this->deleteDistinguishedName($params);
    }
    /**
     * Proxy function to getAccount() to prevent BC break.
     * This API will be removed in a future version. Use 'getAccountDetails' API instead.
     */
    public function getAccount(array $params = [])
    {
        return $this->getAccountDetails($params);
    }
    /**
     * Retrieves all action groups.
     * If 'action_group' is provided in $params, calls 'getActionGroup'.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getActionGroups(array $params = [])
    {
        if (isset($params['action_group'])) {
            $endpoint = $this->endpointFactory->getEndpoint(GetActionGroup::class);
            $action_group = $this->extractArgument($params, 'action_group');
            $endpoint->setActionGroup($action_group);
        } else {
            $endpoint = $this->endpointFactory->getEndpoint(GetActionGroups::class);
        }
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Proxy function to getConfig() to prevent BC break.
     * This API will be removed in a future version. Use 'getConfiguration' API instead.
     */
    public function getConfig(array $params = [])
    {
        return $this->getConfiguration($params);
    }
    /**
     * Retrieves distinguished names. Only accessible to super-admins and with rest-api permissions when enabled.
     * If 'cluster_name' is provided in $params, calls GetDistinguishedName.
     *
     * $params['cluster_name'] = (string) Name of the cluster.
     * $params['show_all']     = (boolean) Show all DN.
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']        = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getDistinguishedNames(array $params = [])
    {
        if (isset($params['cluster_name'])) {
            $endpoint = $this->endpointFactory->getEndpoint(GetDistinguishedName::class);
            $cluster_name = $this->extractArgument($params, 'cluster_name');
            $endpoint->setClusterName($cluster_name);
        } else {
            $endpoint = $this->endpointFactory->getEndpoint(GetDistinguishedNames::class);
        }
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves role mappings. Only accessible to super-admins and with rest-api permissions when enabled.
     * If 'role' is provided in $params, calls GetRoleMapping.
     *
     * $params['role']        = (string) Name of the role.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getRoleMappings(array $params = [])
    {
        if (isset($params['role'])) {
            $endpoint = $this->endpointFactory->getEndpoint(GetRoleMapping::class);
            $role = $this->extractArgument($params, 'role');
            $endpoint->setRole($role);
        } else {
            $endpoint = $this->endpointFactory->getEndpoint(GetRoleMappings::class);
        }
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves roles. Only accessible to super-admins and with rest-api permissions when enabled.
     * If 'role' is provided in $params, calls getRole.
     *
     * $params['role']        = (string) Name of the role.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getRoles(array $params = [])
    {
        if (isset($params['role'])) {
            $endpoint = $this->endpointFactory->getEndpoint(GetRole::class);
            $role = $this->extractArgument($params, 'role');
            $endpoint->setRole($role);
        } else {
            $endpoint = $this->endpointFactory->getEndpoint(GetRoles::class);
        }
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves tenants. Only accessible to super-admins and with rest-api permissions when enabled.
     * If 'tenant' is provided in $params, calls GetTenant.
     *
     * $params['tenant']      = (string) Name of the tenant.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getTenants(array $params = [])
    {
        if (isset($params['tenant'])) {
            $endpoint = $this->endpointFactory->getEndpoint(GetTenant::class);
            $tenant = $this->extractArgument($params, 'tenant');
            $endpoint->setTenant($tenant);
        } else {
            $endpoint = $this->endpointFactory->getEndpoint(GetTenants::class);
        }
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieve all internal users.
     * If 'username' is provided in $params, calls 'getUser'.
     *
     * $params['username']    = (string) The username of the user to fetch, omit to fetch all (optional).
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getUsers(array $params = []): array
    {
        $endpointBuilder = $this->endpoints;

        if (isset($params['username'])) {
            $endpoint = $this->endpointFactory->getEndpoint(GetUser::class);
            $username = $this->extractArgument($params, 'username');
            $endpoint->setUsername($username);
        } else {
            $endpoint = $this->endpointFactory->getEndpoint(GetUsers::class);
        }

        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates, updates, or deletes multiple action groups in a single call.
     * If 'action_group' is provided in $params, calls patchActionGroup.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchActionGroups(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        if ($body === null) {
            $body = $this->extractArgument($params, 'ops') ?? [];
        }

        if (isset($params['action_group'])) {
            $endpoint = $this->endpointFactory->getEndpoint(PatchActionGroup::class);
            $action_group = $this->extractArgument($params, 'action_group');
            $endpoint->setActionGroup($action_group);
        } else {
            $endpoint = $this->endpointFactory->getEndpoint(PatchActionGroups::class);
        }
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Proxy function to patchConfig() to prevent BC break.
     * This API will be removed in a future version. Use 'patchConfiguration' API instead.
     */
    public function patchConfig(array $params = [])
    {
        $ops = $this->extractArgument($params, 'ops');
        if ($ops !== null) {
            $params['body'] = $ops;
        }
        return $this->patchConfiguration($params);
    }
    /**
     * Creates or updates multiple role mappings in a single call.
     *  If 'role' is provided in $params, calls patchRoleMappings.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchRoleMappings(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = $this->extractArgument($params, 'ops') ?? [];
        }

        if (isset($params['role'])) {
            $endpoint = $this->endpointFactory->getEndpoint(PatchRoleMapping::class);
            $role = $this->extractArgument($params, 'role');
            $endpoint->setRole($role);
        } else {
            $endpoint = $this->endpointFactory->getEndpoint(PatchRoleMappings::class);
        }
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates, updates, or deletes multiple roles in a single call.
     * If 'role' is provided in $params, calls patchRole.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchRoles(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = $this->extractArgument($params, 'ops') ?? [];
        }

        if (isset($params['role'])) {
            $endpoint = $this->endpointFactory->getEndpoint(PatchRole::class);
            $role = $this->extractArgument($params, 'role');
            $endpoint->setRole($role);
        } else {
            $endpoint = $this->endpointFactory->getEndpoint(PatchRoles::class);
        }

        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Add, delete, or modify multiple tenants in a single call.
     * If 'tenant' is provided in $params, calls 'patchTenant'.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchTenants(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = $this->extractArgument($params, 'ops') ?? [];
        }

        if (isset($params['tenant'])) {
            $endpoint = $this->endpointFactory->getEndpoint(PatchTenant::class);
            $tenant = $this->extractArgument($params, 'tenant');
            $endpoint->setTenant($tenant);
        } else {
            $endpoint = $this->endpointFactory->getEndpoint(PatchTenants::class);
        }

        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates, updates, or deletes multiple internal users in a single call.
     * If 'username' is provided in $params, calls patchUser.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchUsers(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = $this->extractArgument($params, 'ops') ?? [];
        }

        if (isset($params['username'])) {
            $endpoint = $this->endpointFactory->getEndpoint(PatchUser::class);
            $username = $this->extractArgument($params, 'username');
            $endpoint->setUsername($username);
        } else {
            $endpoint = $this->endpointFactory->getEndpoint(PatchUsers::class);
        }

        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Proxy function to updateConfig() to prevent BC break.
     * This API will be removed in a future version. Use 'updateConfiguration' API instead.
     */
    public function updateConfig(array $params = [])
    {
        $body = [ 'dynamic' => $this->extractArgument($params, 'dynamic')];
        $params['body'] = $body;
        return $this->updateConfiguration($params);
    }
    /**
     * Proxy function to updateDistinguishedNames() to prevent BC break.
     * This API will be removed in a future version. Use 'updateDistinguishedName' API instead.
     */
    public function updateDistinguishedNames(array $params = [])
    {
        $body = [ 'nodes_dn' => $this->extractArgument($params, 'nodes_dn')];
        $params['body'] = $body;
        return $this->updateDistinguishedName($params);
    }
}
