<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Sendinblue\Sendinblue\Setup\Patch\Data;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;

/**
 * Class AddCountryCode
 * @package Sendinblue\Sendinblue\Setup\Patch
 */
class AddCountryCode implements DataPatchInterface, PatchVersionInterface
{
    /**
     * @var ModuleDataSetupInterface $moduleDataSetup
     */
    private $moduleDataSetup;

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     */
    public function __construct(ModuleDataSetupInterface $moduleDataSetup)
    {
        $this->moduleDataSetup = $moduleDataSetup;
    }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        /**
         * Prepare database for install
         */
        $this->moduleDataSetup->getConnection()->startSetup();
        $columns = ['iso_code', 'country_prefix', 'status', 'created_time', 'update_time'];
        $data = [
            ['AD', '376', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AE', '971', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AF', '93', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AG', '1268', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AI', '1264', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AL', '355', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AM', '374', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AN', '599', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AO', '244', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AQ', '672', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AR', '54', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AS', '1684', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AT', '43', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AU', '61', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AW', '297', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['AZ', '994', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BA', '387', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BB', '1246', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BD', '880', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BE', '32', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BF', '226', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BG', '359', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BH', '973', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BI', '257', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BJ', '229', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BL', '590', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BM', '1441', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BN', '673', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BO', '591', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BR', '55', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BS', '1242', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BT', '975', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BW', '267', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BY', '375', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['BZ', '501', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CA', '1', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CC', '61', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CD', '242', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CF', '236', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CG', '242', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CH', '41', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CI', '225', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CK', '682', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CL', '56', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CM', '237', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CN', '86', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CO', '57', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CR', '506', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CU', '53', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CV', '238', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CX', '61', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CY', '357', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['CZ', '420', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['DE', '49', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['DJ', '253', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['DK', '45', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['DM', '1767', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['DO', '1809', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['DZ', '213', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['EC', '593', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['EE', '372', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['EG', '20', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['EH', '212', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['ER', '291', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['ES', '34', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['ET', '251', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['FI', '358', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['FJ', '679', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['FK', '500', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['FM', '691', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['FO', '298', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['FR', '33', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GA', '241', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GB', '44', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GD', '1473', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GE', '995', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GF', '594', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GH', '233', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GI', '350', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GL', '299', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GM', '220', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GN', '224', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GP', '590', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GQ', '240', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GR', '30', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GT', '502', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GU', '1671', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GW', '245', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['GY', '592', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['HK', '852', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['HN', '504', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['HR', '385', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['HT', '509', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['HU', '36', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['ID', '62', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['IE', '353', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['IL', '972', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['IM', '44', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['IN', '91', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['IO', '246', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['IQ', '964', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['IR', '98', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['IS', '354', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['IT', '39', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['JE', '44', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['JM', '1876', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['JO', '962', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['JP', '81', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['KE', '254', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['KG', '996', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['KH', '855', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['KI', '686', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['KM', '269', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['KN', '1869', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['KP', '850', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['KR', '82', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['KW', '965', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['KY', '1345', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['KZ', '7', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['LA', '856', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['LB', '961', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['LC', '1758', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['LI', '423', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['LK', '94', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['LR', '231', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['LS', '266', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['LT', '370', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['LU', '352', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['LV', '371', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['LY', '218', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MA', '212', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MC', '377', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MD', '373', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['ME', '382', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MF', '1599', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MG', '261', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MH', '692', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MK', '389', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['ML', '223', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MN', '976', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MO', '853', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MP', '1670', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MQ', '596', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MR', '222', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MS', '1664', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MT', '356', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MU', '230', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MV', '960', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MW', '265', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MX', '52', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MY', '60', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['MZ', '258', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['NA', '264', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['NC', '687', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['NE', '227', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['NF', '672', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['NG', '234', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['NI', '505', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['NL', '31', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['NO', '47', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['NP', '977', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['NR', '674', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['NU', '683', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['NZ', '64', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['OM', '968', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['PA', '507', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['PE', '51', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['PF', '689', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['PG', '675', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['PH', '63', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['PK', '92', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['PL', '48', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['PM', '508', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['PN', '870', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['PR', '1', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['PS', '970', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['PT', '351', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['PW', '680', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['PY', '595', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['QA', '974', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['RE', '262', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['RO', '40', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['RS', '381', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['RU', '7', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['RW', '250', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SA', '966', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SB', '677', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SC', '248', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SD', '249', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SE', '46', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SG', '65', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SH', '290', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SI', '386', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SJ', '47', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SK', '421', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SL', '232', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SM', '378', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SN', '221', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SO', '252', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SR', '597', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['ST', '239', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SV', '503', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SY', '963', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['SZ', '268', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TC', '1649', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TD', '235', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TF', '262', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TG', '228', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TH', '66', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TJ', '992', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TK', '690', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TL', '670', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TM', '993', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TN', '216', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TO', '676', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TR', '90', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TT', '1868', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TV', '688', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TW', '886', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['TZ', '255', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['UA', '380', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['UG', '256', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['UM', '1', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['US', '1', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['UY', '598', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['UZ', '998', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['VA', '39', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['VC', '1784', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['VE', '58', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['VG', '1284', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['VI', '1340', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['VN', '84', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['VU', '678', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['WF', '681', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['WS', '685', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['YE', '967', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['YT', '262', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['ZA', '27', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['ZM', '260', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
            ['ZW', '263', 1, date('Y-m-d H:i:s'), date('Y-m-d H:i:s')],
        ];

        $this->moduleDataSetup->getConnection()->insertArray(
            $this->moduleDataSetup->getTable('sendinblue_country_codes'),
            $columns,
            $data
        );
        /**
         * Prepare database after install
         */
        $this->moduleDataSetup->getConnection()->endSetup();
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public static function getVersion()
    {
        return '2.0.0';
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        return [];
    }
}
