<?php

namespace StripeIntegration\Payments\Test\Integration\Frontend\CheckoutPage\EmbeddedFlow\AuthorizeCapture\SubscriptionInitialFee;

/**
 * Magento 2.3.7-p3 does not enable these at class level
 * @magentoAppIsolation enabled
 * @magentoDbIsolation enabled
 */
class InitialFeeTest extends \PHPUnit\Framework\TestCase
{
    private $quote;

    public function setUp(): void
    {
        $this->quote = new \StripeIntegration\Payments\Test\Integration\Helper\Quote();
    }

    /**
     * @magentoConfigFixture current_store payment/stripe_payments/payment_flow 0
     *
     * @magentoConfigFixture current_store currency/options/base USD
     * @magentoConfigFixture current_store currency/options/allow EUR,USD
     * @magentoConfigFixture current_store currency/options/default EUR
     */
    public function testInitialFees()
    {
        $this->quote->create()
            ->setCustomer('Guest')
            ->setCart("SubscriptionInitialFee")
            ->setShippingAddress("California")
            ->setShippingMethod("FlatRate")
            ->setBillingAddress("California")
            ->setPaymentMethod("SuccessCard");

        $order = $this->quote->placeOrder();

        $orderItem = null;

        foreach ($order->getAllItems() as $item)
        {
            if ($item->getSku() == "simple-monthly-subscription-initial-fee-product")
            {
                $orderItem = $item;
            }
        }

        $this->assertEquals(2.55, $orderItem->getInitialFee());
        $this->assertEquals(3.0, $orderItem->getBaseInitialFee());
        $this->assertEquals(0.21, $orderItem->getInitialFeeTax());
        $this->assertEquals(0.25, $orderItem->getBaseInitialFeeTax());
    }
}
