<?php
/**
 * Copyright (c) 2020. Volodymyr Hryvinskyi.  All rights reserved.
 * @author: <mailto:volodymyr@hryvinskyi.com>
 * @github: <https://github.com/hryvinskyi>
 */

declare(strict_types=1);

namespace MageCloud\SeoRatingSnippet\Model;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

/**
 * Class Config
 */
class Config
{
    /**
     *  Configuration paths
     */
    const XML_PATH_GENERAL_ENABLED_MOULE = 'magecloud_seo_rich_snippet/general/enabled';
    const XML_PATH_GENERAL_VALUE = 'magecloud_seo_rich_snippet/general/value';
    const XML_PATH_GENERAL_COUNT = 'magecloud_seo_rich_snippet/general/count';

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * Config constructor.
     *
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    public function isEnabled(): bool
    {
        return $this->scopeConfig->isSetFlag(
            self::XML_PATH_GENERAL_ENABLED_MOULE,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->scopeConfig->getValue(
            self::XML_PATH_GENERAL_VALUE,
            ScopeInterface::SCOPE_STORE
        ) ?? '0';
    }

    /**
     * @return string
     */
    public function getCount(): string
    {
        return $this->scopeConfig->getValue(
            self::XML_PATH_GENERAL_COUNT,
            ScopeInterface::SCOPE_STORE
        ) ?? '0';
    }
}