<?php

namespace MageCloud\SubCategoriesCatalog\ViewModel\Catalog;

use Magento\Framework\View\Element\Block\ArgumentInterface,
    Magento\Framework\Registry,
    MageCloud\SubCategoriesCatalog\Plugin\Catalog\Model\Category\Attribute\Source\Mode;

class SubCategories implements ArgumentInterface
{
    private $coreRegistry;

    public function __construct(
        Registry $registry
    ) {
        $this->coreRegistry = $registry;
    }

    public function isSubCategoriesMode(): bool {
        $currentCategory = $this->coreRegistry->registry('current_category');
        return $currentCategory->getDisplayMode() == Mode::SUB_CATEGORIES_MODE;
    }

    public function isSubCategoriesWithProductsMode(): bool {
        $currentCategory = $this->coreRegistry->registry('current_category');
        return $currentCategory->getDisplayMode() == Mode::SUB_CATEGORIES_WITH_PRODUCTS_MODE;
    }
}