<?php
namespace Magebees\Gdpr\Controller\Account;
use Exception;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Controller\AbstractAccount;
use Magento\Customer\Model\Session;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\DataObject;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Registry;
use Magento\Framework\Stdlib\Cookie\CookieMetadataFactory;
use Magento\Framework\Stdlib\Cookie\PhpCookieManager;
use Magebees\Gdpr\Helper\Data;
use Psr\Log\LoggerInterface;

class Delete extends AbstractAccount
{
    protected $_customerRepository;
    protected $_customerSession;
    protected $registry;
    protected $logger;
    protected $_helper;
    private $cookieMetadataFactory;
    private $cookieMetadataManager;

    public function __construct(
        Context $context,
        CustomerRepositoryInterface $customerRepository,
        Session $customerSession,
        Registry $registry,
        LoggerInterface $logger,
        Data $helper
    ) {
        $this->_customerRepository = $customerRepository;
        $this->_customerSession = $customerSession;
        $this->registry = $registry;
        $this->logger = $logger;
        $this->_helper = $helper;

        parent::__construct($context);
    }
    public function execute()
    {
        if (!$this->_helper->allowDeleteAccount() || !$this->_customerSession->isLoggedIn()) {
            $this->registry->register('use_page_cache_plugin', false);
            $this->_forward('noRoute');
            return;
        }

        $customerId = $this->_customerSession->getCustomerId();
        $customer = $this->_customerRepository->getById($customerId);
        $checktoken = new DataObject(['flag' => true]);

        $this->_eventManager->dispatch('anonymise_account_before_delete', compact('customer', 'checktoken'));

        if (!$checktoken->getFlag()) {
            $this->registry->register('use_page_cache_plugin', false);
            $this->_forward('noRoute');

            return;
        }
        $resultRedirect = $this->resultRedirectFactory->create();
        try {
            $this->registry->register('isSecureArea', true, true);
            $this->_customerSession->logout();
            $this->_customerRepository->deleteById($customerId);
			
            $this->_eventManager->dispatch('anonymise_account_after_delete', ['customer' => $customer]);

            if ($this->getCookieManager()->getCookie('mage-cache-sessid')) {
                $metadata = $this->getCookieMetadataFactory()->createCookieMetadata();
                $metadata->setPath('/');
                $this->getCookieManager()->deleteCookie('mage-cache-sessid', $metadata);
            }

            $resultRedirect->setPath('*/*/deleteSuccess');
        } catch (Exception $e) {
            $this->logger->critical($e->getMessage());
            $this->messageManager->addErrorMessage(__('Something wrong while deleting your account. Please contact the store owner.'));
            $resultRedirect->setPath('*/*/');
        }
        return $resultRedirect;
    }
    private function getCookieManager()
    {
        if (!$this->cookieMetadataManager) {
            $this->cookieMetadataManager = ObjectManager::getInstance()->get(PhpCookieManager::class);
        }
        return $this->cookieMetadataManager;
    }
    private function getCookieMetadataFactory()
    {
        if (!$this->cookieMetadataFactory) {
            $this->cookieMetadataFactory = ObjectManager::getInstance()->get(CookieMetadataFactory::class);
        }
        return $this->cookieMetadataFactory;
    }
}