<?php
namespace Magebees\Gdpr\Controller\Address;
use Exception;
use Magento\Customer\Api\AddressRepositoryInterface;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultInterface;

class Delete extends Action
{
	protected $_addressRepository;

    public function __construct(
        Context $context,
        AddressRepositoryInterface $addressRepository
    ) {
        $this->_addressRepository = $addressRepository;
        parent::__construct($context);
    }
    public function execute()
    {
        $addressId = $this->getRequest()->getParam('id');
        try {
            $this->_addressRepository->deleteById($addressId);
            $this->messageManager->addSuccess(__('The address is deleted Successfully'));
            $this->_redirect('customer/address/');
        } catch (Exception $e) {
            $this->messageManager->addError($e->getMessage());
            $this->_redirect('customer/address/');
        }
    }
}