<?php
namespace MpwOwn\BatteryWarranty\Controller;

class Insert extends \Magento\Framework\App\Action\Action
{
  protected $_pageFactory;
  protected $_batteryWarrantyFactory;
  protected $_coreSession;

  public function __construct(
      \Magento\Framework\App\Action\Context $context,
      \Magento\Framework\Session\SessionManagerInterface $coreSession,
      \Magento\Framework\View\Result\PageFactory $pageFactory,
      \MpwOwn\BatteryWarranty\Model\BatteryWarrantyFactory $batteryWarrantyFactory
      )
  {
      $this->_pageFactory = $pageFactory;
      $this->_batteryWarrantyFactory = $batteryWarrantyFactory;
      $this->_coreSession = $coreSession;
      return parent::__construct($context);
  }

  public function execute()
  {
    if ( $this->getRequest()->isPost() ) {

      try {

        $input = $this->getRequest()->getPostValue();

        if (  $this->validateForm($input) ) { throw new \Exception(); }

        $code = $this->genWarrantyCode() ?? '';
        $input['code'] = $code;
        $batteryWarranty = $this->_batteryWarrantyFactory->create();
        $batteryWarranty->setData($input)->save();
        $resultPage = $this->_pageFactory->create();
        $block = $resultPage->getLayout()->getBlock('batterywarranty_index_insert');
        $block->setData('code', $code);

        $this->_coreSession->setMessage('Your request has been sent');

        return $resultPage;

      } catch (\Exception $e) {

        $this->_redirect('*/*/');
        return;
      }

    } else {

      $this->_redirect('*/*/');
      return;
    }
  }

  public function genWarrantyCode()
  {
      return 'ATOM-'.substr(md5(uniqid(mt_rand(), true)), 0, 8);
  }

  public function validateForm( $data )
  {
      $error = false;

      if (!\Zend_Validate::is(trim($data['name']), 'NotEmpty')) {$error = true;}
      if (!\Zend_Validate::is(trim($data['email']), 'NotEmpty')) {$error = true;}
      if (!\Zend_Validate::is(trim($data['email']), 'EmailAddress')) {$error = true;}
      if (!\Zend_Validate::is(trim($data['date']), 'NotEmpty')) {$error = true;}
      if (!\Zend_Validate::is(trim($data['order']), 'NotEmpty')) {$error = true;}
      if (!\Zend_Validate::is(trim($data['bike']), 'NotEmpty')) {$error = true;}

      return $error;
  }
}
