<?php
namespace MpwOwn\BatteryWarranty\Controller\Warranty;

use Magento\Framework\App\Action\Context;
use Magento\Framework\Mail\Template\TransportBuilder;
use Magento\Framework\Session\SessionManagerInterface;
use Magento\Framework\View\Result\PageFactory;
use MpwOwn\BatteryWarranty\Model\BatteryWarrantyFactory;
use Psr\Log\LoggerInterface;

class Insert extends \Magento\Framework\App\Action\Action
{
  protected $_pageFactory;
  protected $_batteryWarrantyFactory;
  protected $_coreSession;
  protected $_transportBuilder;
  protected $_logger;

  public function __construct( Context $context, SessionManagerInterface $coreSession, PageFactory $pageFactory, BatteryWarrantyFactory $batteryWarrantyFactory, TransportBuilder $transportBuilder, LoggerInterface $logger )
  {
      $this->_pageFactory = $pageFactory;
      $this->_batteryWarrantyFactory = $batteryWarrantyFactory;
      $this->_coreSession = $coreSession;
      $this->_transportBuilder = $transportBuilder;
      return parent::__construct($context);
  }

  public function execute()
  {
    if ( $this->getRequest()->isPost() ) {

      try {

        $input = $this->getRequest()->getPostValue();

        if (  $this->validateForm($input) ) { throw new \Exception(); }

        $code = $this->genWarrantyCode() ?? '';

        $date = date_create_from_format('Y-m-d', $input['date']);
        $date = date_format($date, 'Y-m-d H:i:s');
        $attributes = array(
                        'name'        => $input['name'],
                        'tel'         => $input['phone'],
                        'email'       => $input['email'],
                        'platform_id' => $input['platform'],
                        'order_date'  => $date,
                        'order_num'   => $input['order'],
                        'bike'        => $input['bike'],
                        'code'        => $code
                    );

        $batteryWarranty = $this->_batteryWarrantyFactory->create();
        $batteryWarranty->setData($attributes)->save();

        $this->sendWarrantyEmail( $attributes );
        $this->sendWarrantyEmail( $attributes, 'support@motorcyclepartswarehouse.co.uk' );

        $resultPage = $this->_pageFactory->create();
        $block = $resultPage->getLayout()->getBlock('atombattery_warranty_insert');
        $block->setData('code', $code);

        $this->_coreSession->setMessage('Your request has been sent');

        return $resultPage;

      } catch (\Exception $e) {

        $this->_coreSession->setMessage('Unable to send the request.');
        $this->_redirect('*/warranty/error');
        return;
      }

    } else {

      $this->_coreSession->setMessage('Wrong request.');
      $this->_redirect('*/warranty/error');
      return;
    }
  }

  public function genWarrantyCode()
  {
      return 'ATOM-'.substr(md5(uniqid(mt_rand(), true)), 0, 8);
  }

  public function validateForm( $data )
  {
      $error = false;

      if (!\Zend_Validate::is(trim($data['name']), 'NotEmpty')) {$error = true;}
      if (!\Zend_Validate::is(trim($data['email']), 'NotEmpty')) {$error = true;}
      if (!\Zend_Validate::is(trim($data['email']), 'EmailAddress')) {$error = true;}
      if (!\Zend_Validate::is(trim($data['date']), 'NotEmpty')) {$error = true;}
      if (!\Zend_Validate::is(trim($data['order']), 'NotEmpty')) {$error = true;}
      if (!\Zend_Validate::is(trim($data['bike']), 'NotEmpty')) {$error = true;}

      return $error;
  }

  public function sendWarrantyEmail( $attributes, $to = null )
  {

    $emailTempVariables['myvar'] = $attributes;

    $senderName = 'MPW Atom battery warranty';
    $senderEmail = 'customerservices@motorcyclepartswarehouse.co.uk';

    $sender = [
            'name' => $senderName,
            'email' => $senderEmail,
            ];

    $send_to = $to === null ?  $attributes['email'] : $to;
    $template = $to === null ? 'warranty_notification' : 'warranty_application';

    $transport = $this->_transportBuilder->setTemplateIdentifier($template)
      ->setTemplateOptions([ 'area' => \Magento\Framework\App\Area::AREA_FRONTEND, 'store' => \Magento\Store\Model\Store::DEFAULT_STORE_ID ])
      ->setTemplateVars([ 'data' => $emailTempVariables ])
      ->setFrom($sender)
      ->addTo($send_to)
      ->setReplyTo($senderEmail)
      ->getTransport();

    try {

      $transport->sendMessage();

    } catch (\Exception $e) {

      $this->_logger->critical($e->getMessage());

    }

    return true;
  }
}
