<?php
namespace MpwOwn\BatteryWarranty\Model;

use Magento\Framework\Model\AbstractModel;
use MpwOwn\BatteryWarranty\Api\Data\BatteryWarrantyInterface;
use Magento\Framework\DataObject\IdentityInterface;

class BatteryWarranty extends AbstractModel implements IdentityInterface, BatteryWarrantyInterface
{
    const CACHE_TAG = 'mpwown_batterywarranty_batterywarranty';

    protected $_cacheTag = 'mpwown_batterywarranty_batterywarranty';

    protected $_eventPrefix = 'mpwown_batterywarranty_batterywarranty';

    protected function _construct()
    {
        $this->_init('MpwOwn\BatteryWarranty\Model\ResourceModel\BatteryWarranty');
    }

    public function getId() {

        return $this->getData(self::ID);
    }

    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    public function getDefaultValues()
    {
        $values = [];

        return $values;
    }
}
