<?php
namespace Magento\Eav\Api\Data;

/**
 * Extension class for @see \Magento\Eav\Api\Data\AttributeInterface
 */
class AttributeExtension extends \Magento\Framework\Api\AbstractSimpleObject implements AttributeExtensionInterface
{
    /**
     * @return boolean|null
     */
    public function getIsPagebuilderEnabled()
    {
        return $this->_get('is_pagebuilder_enabled');
    }

    /**
     * @param boolean $isPagebuilderEnabled
     * @return $this
     */
    public function setIsPagebuilderEnabled($isPagebuilderEnabled)
    {
        $this->setData('is_pagebuilder_enabled', $isPagebuilderEnabled);
        return $this;
    }

    /**
     * @return \Amasty\ShopbyBase\Api\Data\FilterSettingInterface|null
     */
    public function getFilterSetting()
    {
        return $this->_get('filter_setting');
    }

    /**
     * @param \Amasty\ShopbyBase\Api\Data\FilterSettingInterface $filterSetting
     * @return $this
     */
    public function setFilterSetting(\Amasty\ShopbyBase\Api\Data\FilterSettingInterface $filterSetting)
    {
        $this->setData('filter_setting', $filterSetting);
        return $this;
    }
}
