<?php
namespace Magento\Quote\Api\Data;

/**
 * Extension class for @see \Magento\Quote\Api\Data\ShippingMethodInterface
 */
class ShippingMethodExtension extends \Magento\Framework\Api\AbstractSimpleObject implements ShippingMethodExtensionInterface
{
    /**
     * @return string|null
     */
    public function getDescription()
    {
        return $this->_get('description');
    }

    /**
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->setData('description', $description);
        return $this;
    }

    /**
     * @return string[]|null
     */
    public function getCustom()
    {
        return $this->_get('custom');
    }

    /**
     * @param string[] $custom
     * @return $this
     */
    public function setCustom($custom)
    {
        $this->setData('custom', $custom);
        return $this;
    }
}
