<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Parts Finder for Magento 2
 */
/**
 * Copyright © 2015 Amasty. All rights reserved.
 */

namespace Amasty\Finder\Block\Adminhtml\Finder\Edit\Tab\Products;

use Magento\Backend\Block\Widget;
use Magento\Backend\Block\Widget\Grid\Column;
use Magento\Catalog\Ui\Component\Product\MassAction;

class Grid extends \Amasty\Finder\Block\Adminhtml\Finder\Edit\Tab\AbstractGrid
{

    /**
     * @return \Amasty\Finder\Block\Adminhtml\Finder\Edit\Tab\AbstractGrid
     */
    protected function _prepareCollection()
    {
        $finder = $this->getFinder();
        $this->productCollection->joinAllFor($finder);
        $this->setCollection($this->productCollection);
        return parent::_prepareCollection();
    }

    /**
     * Add column filtering conditions to collection
     *
     * @param Column $column
     * @return Widget
     */
    protected function _addColumnFilterToCollection($column): Widget
    {
        if ($column->getType() === MassAction::NAME && $this->getCollection()) {
            $column->setFilterIndex('finderMap.id');
        }

        return parent::_addColumnFilterToCollection($column);
    }
}
