<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-optimize
 * @version   2.1.13
 * @copyright Copyright (C) 2025 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\OptimizeImage\Plugin;


use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem;
use Magento\Framework\Model\AbstractModel;
use Mirasvit\OptimizeImage\Api\Data\FileInterface;
use Mirasvit\OptimizeImage\Repository\FileRepository;

class CleanupAfterImageCacheDeletePlugin
{
    const DIR_PATH = 'catalog/product/cache';

    private $filesystem;

    private $fileRepository;

    public function __construct(Filesystem $filesystem, FileRepository $fileRepository)
    {
        $this->filesystem     = $filesystem;
        $this->fileRepository = $fileRepository;
    }

    public function afterClearCache(AbstractModel $subject)
    {
        $directoryWrite = $this->filesystem->getDirectoryWrite(DirectoryList::MEDIA);
        $absPath = $directoryWrite->getAbsolutePath('iopt/' . self::DIR_PATH);
        $directoryWrite->delete($absPath);

        $filesCollection = $this->fileRepository->getCollection()
            ->addFieldToFilter(FileInterface::RELATIVE_PATH, ['like' => '%' . self::DIR_PATH . '%']);

        foreach ($filesCollection as $file) {
            $this->fileRepository->delete($file);
        }
    }
}
