<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-optimize
 * @version   2.1.13
 * @copyright Copyright (C) 2025 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\OptimizeImage\Plugin;

use Magento\Swatches\Model\Swatch;
use Mirasvit\Core\Service\SerializeService;
use Mirasvit\OptimizeImage\Service\WebpService;

/**
 * @see \Magento\Swatches\Block\Product\Renderer\Configurable
 */
class ReplaceSwatchesWithWebpPlugin extends ReplaceWebpInProductGalleryPlugin
{
    public function afterGetJsonConfig($subject, string $result): string
    {
        if (!$this->configProvider->isWebpEnabled()) {
            return $result;
        }

        $optionsConfig = SerializeService::decode($result);

        if (!is_array($optionsConfig) || !isset($optionsConfig['images'])) {
            return $result;
        }

        foreach ($optionsConfig['images'] as $key => $config) {
            $optionsConfig['images'][$key] = $this->processImagesConfig($config);
        }

        return SerializeService::encode($optionsConfig);
    }

    /**
     * @SuppressWarnings(PHPMD.CyclomaticComplexity)
     */
    public function afterGetJsonSwatchConfig($subject, string $result): string
    {
        if (!$this->configProvider->isWebpEnabled()) {
            return $result;
        }

        $swatchConfig = SerializeService::decode($result);

        if (!is_array($swatchConfig)) {
            return $result;
        }

        foreach ($swatchConfig as $attrId => $attrConfig) {
            foreach ($attrConfig as $optId => $optConfig) {
                if (!isset($optConfig['type']) || $optConfig['type'] != Swatch::SWATCH_TYPE_VISUAL_IMAGE) {
                    continue;
                }

                foreach ($optConfig as $k => $v) {
                    if (!in_array($k, ['value', 'thumb'])) {
                        continue;
                    }

                    if (!isset($this->processedImages[$v])) {
                        $this->processedImages[$v] = $this->webpService->getImageWebpUrl($v);
                    }

                    $optConfig[$k] = $this->processedImages[$v];
                }

                $attrConfig[$optId] = $optConfig;
            }

            $swatchConfig[$attrId] = $attrConfig;
        }

        return SerializeService::encode($swatchConfig);
    }
}
