<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-optimize
 * @version   2.1.13
 * @copyright Copyright (C) 2025 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\OptimizeImage\Setup\Patch\Schema;


use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\SchemaPatchInterface;
use Magento\Framework\Setup\Patch\PatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
use Mirasvit\OptimizeImage\Api\Data\FileInterface;
use Mirasvit\OptimizeImage\Model\ConfigProvider;
use Mirasvit\OptimizeImage\Repository\FileRepository;


class RemoveOldImagesPatch implements SchemaPatchInterface, PatchVersionInterface
{
    private $setup;

    private $configProvider;

    private $fileRepository;

    public function __construct(
        ModuleDataSetupInterface $setup,
        ConfigProvider $configProvider,
        FileRepository $fileRepository
    ) {
        $this->setup          = $setup;
        $this->configProvider = $configProvider;
        $this->fileRepository = $fileRepository;
    }

    public static function getDependencies()
    {
        return [];
    }

    public function getAliases()
    {
        return [];
    }

    public static function getVersion()
    {
        return '1.0.6';
    }

    public function apply()
    {
        $this->setup->startSetup();

        foreach ($this->fileRepository->getCollection() as $file) {
            $absPath = $this->configProvider->getAbsolutePath($file->getRelativePath());

            if (file_exists($absPath . ConfigProvider::BACKUP_SUFFIX)) {
                rename($absPath . ConfigProvider::BACKUP_SUFFIX, $absPath);
            }

            if (!$file->getWebpPath()) {
                continue;
            }

            $webpPath = $this->configProvider->getAbsolutePath($file->getWebpPath());

            if (file_exists($webpPath)) {
                unlink($webpPath);
            }
        }

        $this->setup->getConnection()->truncateTable($this->setup->getTable(FileInterface::TABLE_NAME));

        $this->setup->endSetup();
    }
}
