<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-search-ultimate
 * @version   2.3.13
 * @copyright Copyright (C) 2025 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Search\Index\Blackbird\ContentManager\Content;

use Mirasvit\Search\Index\AbstractInstantProvider;
use Magento\Framework\App\ObjectManager;
use Mirasvit\Search\Service\IndexService;

class InstantProvider extends AbstractInstantProvider
{
    private $objectManager;

    private $urlBuilder = null;

    public function __construct(
        IndexService $indexService
    ) {
        parent::__construct($indexService);
        $this->objectManager = ObjectManager::getInstance();
    }

    public function getItems(int $storeId, int $limit, int $page = 1): array
    {
        $items = [];

        foreach ($this->getCollection($limit) as $model) {
            $items[] = $this->mapItem($model, $storeId);
        }

        return $items;
    }

    public function getSize(int $storeId): int
    {
        return $this->getCollection(0)->getSize();
    }

    public function map(array $documentData, int $storeId): array
    {
        return $documentData;
    }

    /**
     * @param object $model
     */
    private function mapItem($model, int $storeId): array
    {
        return [
            'name' => $model->getTitle(),
            'url'  => $model->getLinkUrl(),
        ];
    }
}