<?php
/**
 * @author Brevo plateform <contact@brevo.com>
 * @copyright  2012-2023 Brevo
 * URL:  https:www.brevo.com
 * Do not edit or add to this file if you wish to upgrade Brevo Magento plugin to newer
 * versions in the future. If you wish to customize Brevo magento plugin for your
 * needs then we can't provide a technical support.
 **/
namespace Sendinblue\Sendinblue\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Sendinblue\Sendinblue\Model;

/**
 * Customer Observer Model
 */

class SibAutomationObserver implements ObserverInterface
{
    public function execute(Observer $observer)
    {
        ob_start( );
        $userEmail = '';
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $model = $objectManager->create('Sendinblue\Sendinblue\Model\SendinblueSib');
        $customerSession = $objectManager->create('Magento\Customer\Model\Session');
        if ($customerSession->isLoggedIn()) {
            $userEmail = $customerSession->getCustomer()->getEmail();
        }

        $sibStatus = $model->syncSetting();
        $maKey = $model->getDbData('sib_automation_key');
        $trackingStatus = $model->getDbData('sib_track_status');
        if ($sibStatus == 1 && $trackingStatus == 1 && !empty($maKey)) {
            $scriptVal = <<<EOT
                    <script src="https://cdn.brevo.com/js/sdk-loader.js" async></script>
                    <script>
                        window.Brevo = window.Brevo || [];
                        Brevo.push([
                            "init",
                            {
                                client_key: "$maKey",
                                email_id: "$userEmail",
                            },
                        ]);
                    </script>
EOT;
            $scriptVal .= "\n</head>";
            $response   = $observer->getEvent()->getData('response');
            if ( !$response ) {
                return;
            }
            $body = $response->getBody();
            $response->setBody(preg_replace('/<\/head>/', $scriptVal, $body, 1));
            return $this;
        }
    }
}
