<?php

// Sendinblue/Sendinblue/Plugin/CustomTransportPlugin.php
namespace Sendinblue\Sendinblue\Plugin;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Mail\Transport;
use Magento\Framework\Mail\TransportInterface;
use Laminas\Mail\Message;
use Laminas\Mail\Transport\SmtpOptions;
use Laminas\Mail\Transport\Smtp;
use Magento\Framework\Mail\EmailMessage;

class CustomTransportPlugin
{
    const SMTP_PLAIN_AUTH = "plain";

    protected $scopeConfig;

    public function __construct(\Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    public function aroundSendMessage(TransportInterface $subject, callable $proceed)
    {
        // Your custom logic here before calling the original send method
        $relaySib = $this->scopeConfig->getValue('sendinblue/relay_data_status', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

        if ($relaySib == 'enabled') {
            if ($this->scopeConfig->isSetFlag('system/smtp/disable', \Magento\Store\Model\ScopeInterface::SCOPE_STORE)) {
                return null;
            }

            $smtpHost = "smtp-relay.brevo.com";
            $smtpAuthentication = $this->scopeConfig->getValue('sendinblue/smtp_authentication', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
            $smtpTls = $this->scopeConfig->getValue('sendinblue/smtp_tls', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
            $smtpPort = $this->scopeConfig->getValue('sendinblue/smtp_port', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
            $smtpUsername = $this->scopeConfig->getValue('sendinblue/smtp_username', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
            $smtpPassword = $this->scopeConfig->getValue('sendinblue/smtp_password', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

            $options = [
                'host' => $smtpHost,
                'port' => $smtpPort,
                'connection_config' => [
                    'username' => $smtpUsername,
                    'password' => $smtpPassword,
                    'ssl' => $smtpTls,
                ],
            ];

            if (class_exists('\Laminas\Mail\Protocol\Smtp\Auth\Crammd5')) {
                $options['connection_class'] = $smtpAuthentication;
            } else {
                $options['connection_class'] = self::SMTP_PLAIN_AUTH;
            }

            $transport = new Smtp(new SmtpOptions($options));

            if ($subject instanceof EmailMessage) {
                $transport->send($subject->getMessage());
            } else {
                $zendMail = Message::fromString($subject->getMessage()->getRawMessage());
                $zendMail->setEncoding('utf-8');
                $subject = $zendMail->getSubject();
                $zendMail->setSubject(htmlspecialchars_decode((string)$subject, ENT_QUOTES));
                $transport->send($zendMail);
            }
        } else {
            // Call the original send method
            return $proceed();
        }

        return null;
    }
}

